/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.api.bogeymenu.v0.entry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.api.bogeymenu.v0.entry.BogeyEntry;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerClient;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryEntry {
    @NotNull
    private final class_2561 name;
    @NotNull
    private final class_2960 id;
    @NotNull
    private final List<BogeyEntry> bogeyEntryList = new ArrayList<BogeyEntry>();

    public CategoryEntry(@NotNull class_2561 name, @NotNull class_2960 id) {
        this.name = name;
        this.id = id;
    }

    @NotNull
    public class_2561 getName() {
        return this.name;
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    @NotNull
    public List<BogeyEntry> getBogeyEntryList() {
        return this.bogeyEntryList;
    }

    @ApiStatus.Internal
    void addToBogeyEntryList(BogeyEntry entry) {
        this.bogeyEntryList.add(entry);
    }

    public static class FavoritesCategory
    extends CategoryEntry {
        public static final CategoryEntry INSTANCE = new FavoritesCategory();
        @Nullable
        private List<BogeyEntry> cachedEntryList = null;
        private int cachedVersion = -1;

        private FavoritesCategory() {
            super((class_2561)Components.translatable((String)"railways.gui.bogey_menu.category.favorites"), Railways.asResource("favorites"));
        }

        @Override
        @NotNull
        public List<BogeyEntry> getBogeyEntryList() {
            int version = BogeyMenuHandlerClient.getFavorites().hashCode();
            if (this.cachedEntryList == null || this.cachedVersion != version) {
                this.cachedEntryList = new ArrayList<BogeyEntry>();
                for (BogeyStyle style : BogeyMenuHandlerClient.getFavorites()) {
                    if (BogeyEntry.STYLE_TO_ENTRY.containsKey(style)) {
                        this.cachedEntryList.add(BogeyEntry.STYLE_TO_ENTRY.get(style));
                        continue;
                    }
                    this.cachedEntryList.add(BogeyEntry.getOrCreate(style, null, 23.0f));
                }
                this.cachedVersion = version;
            }
            return this.cachedEntryList;
        }

        @Override
        void addToBogeyEntryList(BogeyEntry entry) {
        }
    }
}

