/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_2444;
import net.minecraft.class_2960;

public class RailwaysSequencedAssemblyRecipeBuilder
extends SequencedAssemblyRecipeBuilder {
    public RailwaysSequencedAssemblyRecipeBuilder(class_2960 id) {
        super(id);
    }

    public RailwaysSequencedAssemblyRecipeBuilder conditionalMaterial(TrackMaterial trackMaterial) {
        String namespace = trackMaterial.id.method_12836();
        if (!"railways".equals(namespace)) {
            this.recipeConditions.add(DefaultResourceConditions.allModsLoaded((String[])new String[]{namespace}));
        }
        return this;
    }

    public void build(Consumer<class_2444> consumer) {
        consumer.accept((class_2444)new RailwaysDataGenResult(this.build(), this.recipeConditions));
    }

    public static class RailwaysDataGenResult
    extends SequencedAssemblyRecipeBuilder.DataGenResult {
        private final List<ConditionJsonProvider> recipeConditions;

        public RailwaysDataGenResult(SequencedAssemblyRecipe recipe, List<ConditionJsonProvider> recipeConditions) {
            super(recipe, recipeConditions);
            this.recipeConditions = recipeConditions;
        }

        public void method_10416(JsonObject json) {
            super.method_10416(json);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)this.toForgeJson((ConditionJsonProvider)c)));
            json.add("conditions", (JsonElement)conds);
        }

        private JsonObject toForgeJson(ConditionJsonProvider provider) {
            if (provider.getConditionId().method_12832().equals("all_mods_loaded")) {
                JsonObject original = provider.toJson();
                JsonArray mods = original.getAsJsonArray("values");
                if (mods.size() > 1) {
                    JsonObject condition = new JsonObject();
                    condition.addProperty("type", "forge:and");
                    JsonArray values = new JsonArray();
                    mods.forEach(e -> values.add((JsonElement)this.conditionForgeModLoaded(e.getAsString())));
                    condition.add("values", (JsonElement)values);
                    return condition;
                }
                return this.conditionForgeModLoaded(mods.get(0).getAsString());
            }
            throw new UnsupportedOperationException("This provider only supports the fabric:all_mods_loaded recipe condition.");
        }

        private JsonObject conditionForgeModLoaded(String mod) {
            JsonObject condition = new JsonObject();
            condition.addProperty("type", "forge:mod_loaded");
            condition.addProperty("modid", mod);
            return condition;
        }
    }
}

