/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import com.google.common.collect.Lists;
import fuzs.easyanvils.client.gui.components.TypeActionManager;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public class OpenEditBox
extends class_342 {
    private final class_327 font;
    String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    int displayPos;
    int cursorPos;
    int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (formatterValue, position) -> {
        ArrayList list = Lists.newArrayList();
        FormattedStringDecomposer.LengthLimitedCharSink sink = new FormattedStringDecomposer.LengthLimitedCharSink(formatterValue.length(), (int)position);
        FormattedStringDecomposer.iterateFormatted(this.value, class_2583.field_24360, (index, style, j) -> {
            if (sink.accept(index, style, j)) {
                list.add(formattedCharSink -> formattedCharSink.accept(index, style, j));
            }
            return true;
        });
        return class_5481.method_30749((List)list);
    };
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleClick;
    private int doubleClickHighlightPos;
    private int doubleClickCursorPos;
    public TypeActionManager typeActionManager = new TypeActionManager();

    public OpenEditBox(class_327 font, int i, int j, int k, int l, class_2561 component) {
        this(font, i, j, k, l, null, component);
    }

    public OpenEditBox(class_327 font, int i, int j, int k, int l, @Nullable OpenEditBox editBox, class_2561 component) {
        super(font, i, j, k, l, (class_342)editBox, component);
        this.font = font;
        if (editBox != null) {
            this.method_1852(editBox.method_1882());
        }
    }

    public void method_1863(Consumer<String> responder) {
        this.responder = responder;
    }

    public void method_1854(BiFunction<String, Integer, class_5481> textFormatter) {
        this.formatter = textFormatter;
    }

    public void method_1865() {
        ++this.frame;
    }

    protected class_5250 method_25360() {
        class_2561 component = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void method_1852(String text) {
        if (this.filter.test(text)) {
            int aboveMaxLength = ComponentDecomposer.getStringLength(text) - this.maxLength;
            this.value = aboveMaxLength > 0 ? ComponentDecomposer.removeLast(text, aboveMaxLength) : text;
            this.method_1872();
            this.method_1884(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String method_1882() {
        return this.value;
    }

    public String method_1866() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public boolean hasHighlighted() {
        return this.highlightPos != this.cursorPos;
    }

    public void method_1890(Predicate<String> validator) {
        this.filter = validator;
    }

    public void method_1867(String textToWrite) {
        String string2;
        String string;
        int j;
        int i = Math.min(this.cursorPos, this.highlightPos);
        String string3 = new StringBuilder(this.value).replace(i, j = Math.max(this.cursorPos, this.highlightPos), string = FormattedStringDecomposer.filterText(textToWrite)).toString();
        int stringLength = ComponentDecomposer.getStringLength(string3) - this.maxLength;
        if (stringLength > 0) {
            string = ComponentDecomposer.removeLast(textToWrite, stringLength);
        }
        if (this.filter.test(string2 = new StringBuilder(this.value).replace(i, j, string).toString())) {
            this.value = string2;
            int l = string.length();
            this.method_1875(i + l);
            this.method_1884(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String newText) {
        this.typeActionManager.trySave(this);
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int count) {
        if (class_437.method_25441()) {
            if (count < 0) {
                this.method_1878(-this.cursorPos);
            }
        } else if (class_437.method_25443()) {
            this.method_1877(count);
        } else {
            this.method_1878(count);
        }
    }

    public void method_1877(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.method_1867("");
            } else {
                this.method_1878(this.method_1853(num) - this.cursorPos);
            }
        }
    }

    public void method_1878(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.method_1867("");
            } else {
                String string;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = string;
                    this.method_1883(j);
                }
            }
        }
    }

    public int method_1853(int numWords) {
        return this.getWordPosition(numWords, this.method_1881());
    }

    private int getWordPosition(int n, int pos) {
        return this.getWordPosition(n, pos, true);
    }

    private int getWordPosition(int numWords, int pos, boolean skipConsecutiveSpaces) {
        int i = pos;
        boolean backwards = numWords < 0;
        int skippedWords = Math.abs(numWords);
        for (int k = 0; k < skippedWords; ++k) {
            if (!backwards) {
                int l = this.value.length();
                while (skipConsecutiveSpaces && i == pos && i < l && !OpenEditBox.isWordChar(this.value.charAt(i))) {
                    ++i;
                    ++pos;
                }
                while (i < l && OpenEditBox.isWordChar(this.value.charAt(i))) {
                    ++i;
                }
                continue;
            }
            while (skipConsecutiveSpaces && i == pos && i > 0 && !OpenEditBox.isWordChar(this.value.charAt(i - 1))) {
                --i;
                --pos;
            }
            while (i > 0 && OpenEditBox.isWordChar(this.value.charAt(i - 1))) {
                --i;
            }
        }
        return i;
    }

    private static boolean isWordChar(char charAt) {
        return charAt == '_' || Character.isAlphabetic(charAt) || Character.isDigit(charAt);
    }

    public void method_1855(int delta) {
        this.method_1883(this.getCursorPos(delta));
    }

    private int getCursorPos(int delta) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)delta);
    }

    public void method_1883(int pos) {
        this.method_1875(pos);
        if (!this.shiftPressed) {
            this.method_1884(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void method_1875(int pos) {
        this.cursorPos = class_3532.method_15340((int)pos, (int)0, (int)this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void method_1870() {
        this.method_1883(0);
    }

    public void method_1872() {
        this.method_1883(this.value.length());
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 89 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && class_437.method_25441() && class_437.method_25442() && !class_437.method_25443();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_20315()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.method_1872();
            this.method_1884(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.method_1866());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.isEditable) {
                this.method_1867(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.method_1866());
            if (this.isEditable) {
                this.method_1867("");
            }
            return true;
        }
        if (OpenEditBox.isUndo(keyCode)) {
            this.typeActionManager.undo(this);
            return true;
        }
        if (OpenEditBox.isRedo(keyCode)) {
            this.typeActionManager.redo(this);
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.method_1875(Math.max(this.method_1881(), this.highlightPos));
                    this.method_1884(this.method_1881());
                    canMove = false;
                }
                if (class_437.method_25441()) {
                    this.method_1872();
                } else if (class_437.method_25443()) {
                    this.method_1883(this.method_1853(1));
                } else if (canMove) {
                    this.method_1855(1);
                }
                return true;
            }
            case 263: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.method_1875(Math.min(this.method_1881(), this.highlightPos));
                    this.method_1884(this.method_1881());
                    canMove = false;
                }
                if (class_437.method_25441()) {
                    this.method_1870();
                } else if (class_437.method_25443()) {
                    this.method_1883(this.method_1853(-1));
                } else if (canMove) {
                    this.method_1855(-1);
                }
                return true;
            }
            case 268: {
                this.method_1870();
                return true;
            }
            case 269: 
        }
        this.method_1872();
        return true;
    }

    public boolean method_20315() {
        return this.method_1885() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.method_20315()) {
            return false;
        }
        if (FormattedStringDecomposer.isAllowedChatCharacter(codePoint)) {
            if (this.isEditable) {
                this.method_1867(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public void method_25348(double mouseX, double mouseY) {
        int i = class_3532.method_15357((double)mouseX) - this.method_46426();
        if (this.bordered) {
            i -= 4;
        }
        this.shiftPressed = class_437.method_25442();
        String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
        this.method_1883(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, class_2583.field_24360).length() + this.displayPos);
        long millis = class_156.method_658();
        boolean tripleClick = this.doubleClick;
        boolean bl = this.doubleClick = millis - this.lastClickTime < 250L;
        if (this.doubleClick) {
            if (tripleClick) {
                this.method_1872();
                this.method_1884(0);
            } else {
                this.shiftPressed = false;
                this.doubleClickHighlightPos = this.getWordPosition(1, this.method_1881(), false);
                this.method_1883(this.doubleClickHighlightPos);
                this.shiftPressed = true;
                this.doubleClickCursorPos = this.getWordPosition(-1, this.method_1881(), false);
                this.method_1883(this.doubleClickCursorPos);
                this.shiftPressed = class_437.method_25442();
            }
        }
        this.lastClickTime = millis;
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.method_25361(mouseX, mouseY)) {
            int i = class_3532.method_15357((double)mouseX) - this.method_46426();
            if (this.bordered) {
                i -= 4;
            }
            if (this.doubleClick) {
                String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
                int mousePosition = FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, class_2583.field_24360).length() + this.displayPos;
                this.shiftPressed = false;
                this.method_1883(Math.max(this.doubleClickHighlightPos, this.getWordPosition(1, mousePosition, false)));
                this.shiftPressed = true;
                this.method_1883(Math.min(this.doubleClickCursorPos, this.getWordPosition(-1, mousePosition, false)));
                this.shiftPressed = class_437.method_25442();
            } else {
                this.shiftPressed = true;
                String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
                this.method_1883(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, class_2583.field_24360).length() + this.displayPos);
                this.shiftPressed = class_437.method_25442();
            }
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.method_1885()) {
            int i;
            if (this.isBordered()) {
                i = this.method_25370() ? -1 : -6250336;
                guiGraphics.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, i);
                guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
            }
            i = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.method_1859(), class_2583.field_24360);
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.method_25370() && this.frame / 6 % 2 == 0 && bl;
            int l = this.bordered ? this.method_46426() + 4 : this.method_46426();
            int m = this.bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int n = l;
            if (k > string.length()) {
                k = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                n = guiGraphics.method_35720(this.font, this.formatter.apply(string2, this.displayPos), l, m, i);
            }
            boolean bl3 = this.cursorPos < this.value.length() || ComponentDecomposer.getStringLength(this.value) >= this.getMaxLength();
            int o = n;
            if (!bl) {
                o = j > 0 ? l + this.field_22758 : l;
            } else if (!string.isEmpty()) {
                o = n - 1;
                --n;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                guiGraphics.method_35720(this.font, this.formatter.apply(string.substring(j), this.cursorPos), n, m, i);
            }
            if (!bl3 && this.suggestion != null) {
                guiGraphics.method_25303(this.font, this.suggestion, o - 1, m, -8355712);
            }
            if (bl2 && k == j) {
                if (!string.isEmpty()) {
                    guiGraphics.method_51739(class_1921.method_51785(), o, m - 1, o + 1, m + 1 + 9, -3092272);
                } else {
                    guiGraphics.method_25303(this.font, "_", o, m, i);
                }
            }
            if (k != j) {
                int p = l + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, this.highlightPos), this.displayPos);
                this.renderHighlight(guiGraphics, o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    private void renderHighlight(class_332 guiGraphics, int startX, int startY, int endX, int endY) {
        int i;
        if (startX < endX) {
            i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            i = startY;
            startY = endY;
            endY = i;
        }
        if (endX > this.method_46426() + this.field_22758) {
            endX = this.method_46426() + this.field_22758;
        }
        if (startX > this.method_46426() + this.field_22758) {
            startX = this.method_46426() + this.field_22758;
        }
        guiGraphics.method_51739(class_1921.method_51786(), startX, startY, endX, endY, -16776961);
    }

    public void method_1880(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int method_1881() {
        return this.cursorPos;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void method_1858(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void method_1868(int color) {
        this.textColor = color;
    }

    public void method_1860(int color) {
        this.textColorUneditable = color;
    }

    @Nullable
    public class_8016 method_48205(class_8023 focusNavigationEvent) {
        return this.field_22764 && this.isEditable ? super.method_48205(focusNavigationEvent) : null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public void method_25365(boolean bl) {
        if (this.canLoseFocus || bl) {
            super.method_25365(bl);
            if (bl) {
                this.frame = 0;
            }
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void method_1888(boolean enabled) {
        this.isEditable = enabled;
    }

    public int method_1859() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void method_1884(int position) {
        this.highlightPos = class_3532.method_15340((int)position, (int)0, (int)this.value.length());
        this.scrollTo(this.highlightPos);
    }

    protected void scrollTo(int position) {
        if (this.font != null) {
            int i = this.value.length();
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.method_1859();
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, j, class_2583.field_24360);
            int k = string.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= FormattedStringDecomposer.plainTailByWidth(this.font, this.value, j, class_2583.field_24360).length();
            }
            if (position > k) {
                this.displayPos += position - k;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void method_1856(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean method_1885() {
        return this.field_22764;
    }

    public void method_1862(boolean isVisible) {
        this.field_22764 = isVisible;
    }

    public void method_1887(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int method_1889(int charNum) {
        return charNum > this.value.length() ? this.method_46426() : this.method_46426() + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, charNum), 0);
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }
}

