/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.wrapperInterfaces.chunk;

import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkLightStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    public int minY;
    public int maxY;
    public LightSection[] lightSections;
    public int aboveMaxYValue;
    public int belowMinYValue;

    public static ChunkLightStorage createSkyLightStorage(IChunkWrapper chunkWrapper) {
        return ChunkLightStorage.createSkyLightStorage(chunkWrapper.getInclusiveMinBuildHeight(), chunkWrapper.getExclusiveMaxBuildHeight());
    }

    public static ChunkLightStorage createSkyLightStorage(int minY, int maxY) {
        return new ChunkLightStorage(minY, maxY, 15, 0);
    }

    public static ChunkLightStorage createBlockLightStorage(IChunkWrapper chunkWrapper) {
        return ChunkLightStorage.createBlockLightStorage(chunkWrapper.getInclusiveMinBuildHeight(), chunkWrapper.getExclusiveMaxBuildHeight());
    }

    public static ChunkLightStorage createBlockLightStorage(int minY, int maxY) {
        return new ChunkLightStorage(minY, maxY, 0, 0);
    }

    public ChunkLightStorage(int minY, int maxY, int aboveMaxYValue, int belowMinYValue) {
        this.minY = minY;
        this.maxY = maxY;
        this.aboveMaxYValue = aboveMaxYValue;
        this.belowMinYValue = belowMinYValue;
    }

    public int get(int x, int y, int z) {
        if (y < this.minY) {
            return this.belowMinYValue;
        }
        if (y >= this.maxY) {
            return this.aboveMaxYValue;
        }
        if (this.lightSections != null) {
            int sectionIndex = BitShiftUtil.divideByPowerOfTwo(y - this.minY, 4);
            try {
                LightSection lightSection = this.lightSections[sectionIndex];
                if (lightSection != null) {
                    return lightSection.get(x, y, z);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Failed to get light at x:[" + x + "], y:[" + y + "], z:[" + z + "], index:[" + sectionIndex + "]. MinY:[" + this.minY + "], maxY:[" + this.maxY + "], section length:[" + this.lightSections.length + "].  Original error: [" + e.getMessage() + "].");
            }
        }
        return 0;
    }

    public void set(int x, int y, int z, int lightLevel) {
        int index;
        LightSection lightSection;
        if (y < this.minY || y >= this.maxY) {
            return;
        }
        if (this.lightSections == null) {
            int arrayLength = (this.maxY - this.minY) / 16;
            this.lightSections = new LightSection[arrayLength];
        }
        if ((lightSection = this.lightSections[index = y - this.minY >> 4]) == null) {
            this.lightSections[index] = lightSection = new LightSection(0);
        }
        lightSection.set(x, y, z, lightLevel);
    }

    public void clear() {
        if (this.lightSections != null) {
            for (int i = 0; i < this.lightSections.length; ++i) {
                LightSection section = this.lightSections[i];
                if (section == null) continue;
                section.constantValue = 0;
                if (section.data == null) continue;
                Arrays.fill(section.data, 0L);
            }
        }
    }

    public static class LightSection {
        public byte constantValue;
        public long[] data;
        public short[] counts;
        private final ReentrantLock concurrencyCheckLock = new ReentrantLock();

        public LightSection(int initialValue) {
            if (initialValue < 0) {
                throw new IllegalArgumentException("The initial light value must be greater than [0].");
            }
            this.constantValue = (byte)initialValue;
            this.counts = new short[16];
            this.counts[initialValue] = 4096;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get(int x, int y, int z) {
            if (!this.concurrencyCheckLock.tryLock()) {
                throw new ConcurrentModificationException("Thread [" + Thread.currentThread().getName() + "] attempted to get chunk light, lock: [" + this.concurrencyCheckLock + "].");
            }
            try {
                if (this.constantValue >= 0) {
                    byte by = this.constantValue;
                    return by;
                }
                long bits = this.data[(z &= 0xF) << 4 | (x &= 0xF)];
                int n = (int)(bits >>> ((y &= 0xF) << 2)) & 0xF;
                return n;
            }
            finally {
                this.concurrencyCheckLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int x, int y, int z, int lightLevel) {
            if (!this.concurrencyCheckLock.tryLock()) {
                throw new ConcurrentModificationException("Thread [" + Thread.currentThread().getName() + "] attempted to set chunk light, lock: [" + this.concurrencyCheckLock + "].");
            }
            try {
                int oldLightLevel = -1;
                if (this.constantValue >= 0) {
                    oldLightLevel = this.constantValue;
                    if (oldLightLevel == lightLevel) {
                        return;
                    }
                    this.data = DataRecycler.get();
                    LodUtil.assertTrue(this.data != null);
                    long payload = oldLightLevel;
                    payload |= payload << 4;
                    payload |= payload << 8;
                    payload |= payload << 16;
                    payload |= payload << 32;
                    Arrays.fill(this.data, payload);
                    this.constantValue = (byte)-1;
                }
                y &= 0xF;
                int index = (z &= 0xF) << 4 | (x &= 0xF);
                long bits = this.data[index];
                if (oldLightLevel < 0) {
                    oldLightLevel = (int)(bits >>> (y << 2)) & 0xF;
                }
                bits &= 15L << (y << 2) ^ 0xFFFFFFFFFFFFFFFFL;
                this.data[index] = bits |= (long)lightLevel << (y << 2);
                int n = oldLightLevel;
                this.counts[n] = (short)(this.counts[n] - 1);
                int n2 = lightLevel;
                this.counts[n2] = (short)(this.counts[n2] + 1);
                if (this.counts[n2] == 4096) {
                    this.constantValue = (byte)lightLevel;
                    LodUtil.assertTrue(this.constantValue >= 0);
                    DataRecycler.reclaim(this.data);
                    this.data = null;
                }
            }
            finally {
                this.concurrencyCheckLock.unlock();
            }
        }
    }

    static class DataRecycler {
        private static final ArrayList<long[]> ARRAY_LIST = new ArrayList(256);
        private static final ReentrantLock ACCESS_LOCK = new ReentrantLock();

        DataRecycler() {
        }

        static long[] get() {
            try {
                ACCESS_LOCK.lock();
                if (ARRAY_LIST.isEmpty()) {
                    long[] lArray = new long[256];
                    return lArray;
                }
                long[] lArray = ARRAY_LIST.remove(ARRAY_LIST.size() - 1);
                return lArray;
            }
            finally {
                ACCESS_LOCK.unlock();
            }
        }

        static void reclaim(long[] data) {
            try {
                ACCESS_LOCK.lock();
                if (ARRAY_LIST.size() < 256) {
                    ARRAY_LIST.add(data);
                }
            }
            finally {
                ACCESS_LOCK.unlock();
            }
        }
    }
}

