/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_918;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.Tab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTab;

public abstract class StorageSettingsTabControlBase
extends SettingsTabControl<SettingsScreen, SettingsTab<?>> {
    private final List<SettingsTab<?>> settingsTabs = new ArrayList();
    protected final SettingsScreen screen;

    protected static <C extends SettingsContainerBase<?>, T extends SettingsTab<C>> void addFactory(ImmutableMap.Builder<String, ISettingsTabFactory<?, ?>> builder, String categoryName, ISettingsTabFactory<C, T> factory) {
        builder.put((Object)categoryName, factory);
    }

    protected StorageSettingsTabControlBase(SettingsScreen screen, Position position) {
        super(position);
        this.screen = screen;
        this.addChild(this.instantiateReturnBackTab());
        ((SettingsContainerMenu)screen.method_17577()).forEachSettingsContainer((categoryName, settingsContainer) -> {
            if (this.isSettingsCategoryDisabled((String)categoryName)) {
                return;
            }
            this.settingsTabs.add(this.addSettingsTab(() -> {}, () -> {}, this.instantiateContainer((String)categoryName, (SettingsContainerBase)settingsContainer, new Position(this.x, this.getTopY()), screen)));
        });
    }

    protected boolean isSettingsCategoryDisabled(String categoryName) {
        return false;
    }

    protected abstract Tab instantiateReturnBackTab();

    public void renderSlotOverlays(class_332 guiGraphics, class_1735 slot, ISlotOverlayRenderer overlayRenderer, boolean templateLoadHovered) {
        ArrayList colors = new ArrayList();
        this.settingsTabs.forEach(tab -> tab.getSlotOverlayColor(slot.field_7874, templateLoadHovered).ifPresent(colors::add));
        if (colors.isEmpty()) {
            return;
        }
        int stripeHeight = 16 / colors.size();
        int i = 0;
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            int yOffset = i * stripeHeight;
            overlayRenderer.renderSlotOverlay(guiGraphics, slot.field_7873, slot.field_7872 + yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight, color);
            ++i;
        }
    }

    public class_1799 getSlotStackDisplayOverride(int slotNumber, boolean isTemplateLoadHovered) {
        for (SettingsTab<?> settingsTab : this.settingsTabs) {
            class_1799 stack = settingsTab.getItemDisplayOverride(slotNumber, isTemplateLoadHovered);
            if (stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public void renderSlotExtra(class_332 guiGraphics, class_1735 slot) {
        this.settingsTabs.forEach(tab -> tab.renderExtra(guiGraphics, slot));
    }

    public void handleSlotClick(class_1735 slot, int mouseButton) {
        this.getOpenTab().ifPresent(tab -> tab.handleSlotClick(slot, mouseButton));
    }

    public boolean renderGuiItem(class_332 guiGraphics, class_918 itemRenderer, class_1799 itemstack, class_1735 slot, boolean templateLoadHovered) {
        for (SettingsTab<?> tab : this.settingsTabs) {
            int rotation = tab.getItemRotation(slot.field_7874, templateLoadHovered);
            if (rotation == 0) continue;
            GuiHelper.tryRenderGuiItem(itemRenderer, (class_1309)this.minecraft.field_1724, itemstack, slot.field_7873, slot.field_7872, rotation);
            return true;
        }
        if (!itemstack.method_7960()) {
            guiGraphics.method_51427(itemstack, slot.field_7873, slot.field_7872);
            return true;
        }
        return false;
    }

    public void drawSlotStackOverlay(class_332 guiGraphics, class_1735 slot, boolean templateLoadHovered) {
        for (SettingsTab<?> tab : this.settingsTabs) {
            tab.drawSlotStackOverlay(guiGraphics, slot, templateLoadHovered);
        }
    }

    private <C extends SettingsContainerBase<?>> SettingsTab<C> instantiateContainer(String categoryName, C container, Position position, SettingsScreen screen) {
        return this.getSettingsTabFactory(categoryName).create(container, position, screen);
    }

    protected abstract <C extends SettingsContainerBase<?>, T extends SettingsTab<C>> ISettingsTabFactory<C, T> getSettingsTabFactory(String var1);

    public static interface ISlotOverlayRenderer {
        public void renderSlotOverlay(class_332 var1, int var2, int var3, int var4, int var5);
    }

    public static interface ISettingsTabFactory<C extends SettingsContainerBase<?>, T extends SettingsTab<C>> {
        public T create(C var1, Position var2, SettingsScreen var3);
    }
}

