/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.trains;

import com.hlysine.create_power_loader.CPLBlocks;
import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;

public class CarriageChunkLoader
implements ChunkLoader {
    public final Carriage carriage;
    public boolean known;
    public boolean andesite;
    public boolean brass;
    public final Set<ChunkLoadManager.LoadedChunkPos> forcedChunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();

    public CarriageChunkLoader(Carriage carriage, boolean known, boolean andesite, boolean brass) {
        this.carriage = carriage;
        this.known = known;
        this.andesite = andesite;
        this.brass = brass;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        return this.forcedChunks;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.TRAIN;
    }

    @Override
    public LoaderType getLoaderType() {
        return this.brass ? LoaderType.BRASS : LoaderType.ANDESITE;
    }

    @Override
    public Pair<class_2960, class_2338> getLocation() {
        if (this.carriage.train.graph == null) {
            return null;
        }
        return Pair.of((Object)this.carriage.leadingBogey().trailing().node1.getLocation().getDimension().method_29177(), (Object)class_2338.method_49638((class_2374)this.carriage.leadingBogey().trailing().getPosition(this.carriage.train.graph)));
    }

    public void tick(class_1937 level) {
        if (!this.known) {
            this.updateCarriage();
        }
        if (!this.known) {
            return;
        }
        if (!this.canLoadChunks()) {
            if (!this.forcedChunks.isEmpty()) {
                ChunkLoadManager.unforceAllChunks(level.method_8503(), this.carriage.train.id, this.forcedChunks);
            }
            return;
        }
        HashSet<ChunkLoadManager.LoadedChunkPos> loadTargets = new HashSet<ChunkLoadManager.LoadedChunkPos>();
        this.addLoadTargets(loadTargets, this.carriage.leadingBogey().trailing());
        this.addLoadTargets(loadTargets, this.carriage.trailingBogey().leading());
        ChunkLoadManager.updateForcedChunks(level.method_8503(), loadTargets, this.carriage.train.id, (int)((Integer)CPLConfigs.server().getFor((LoaderType)this.getLoaderType()).rangeOnTrain.get()), this.forcedChunks);
    }

    public void onRemove() {
        ChunkLoadManager.enqueueUnforceAll(this.carriage.train.id, this.forcedChunks);
    }

    private void addLoadTargets(Set<ChunkLoadManager.LoadedChunkPos> loadTargets, TravellingPoint point) {
        if (point.edge.isInterDimensional()) {
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(point.node1.getLocation().getDimension().method_29177(), new class_1923(class_2338.method_49638((class_2374)point.node1.getLocation().getLocation()))));
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(point.node2.getLocation().getDimension().method_29177(), new class_1923(class_2338.method_49638((class_2374)point.node2.getLocation().getLocation()))));
        } else {
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(point.node1.getLocation().getDimension().method_29177(), new class_1923(class_2338.method_49638((class_2374)point.getPosition(this.carriage.train.graph)))));
        }
    }

    private void updateCarriage() {
        CarriageContraptionEntity entity = this.carriage.anyAvailableEntity();
        boolean bl = this.known = entity != null;
        if (!this.known) {
            return;
        }
        Contraption contraption = entity.getContraption();
        this.andesite = !contraption.isActorTypeDisabled(class_1799.field_8037) && !contraption.isActorTypeDisabled(CPLBlocks.ANDESITE_CHUNK_LOADER.asStack());
        boolean bl2 = this.brass = !contraption.isActorTypeDisabled(class_1799.field_8037) && !contraption.isActorTypeDisabled(CPLBlocks.BRASS_CHUNK_LOADER.asStack());
        if (!this.andesite && !this.brass) {
            return;
        }
        boolean hasAndesite = false;
        boolean hasBrass = false;
        for (MutablePair actor : entity.getContraption().getActors()) {
            if (!hasAndesite && ((class_3499.class_3501)actor.left).comp_1342().method_27852((class_2248)CPLBlocks.ANDESITE_CHUNK_LOADER.get())) {
                hasAndesite = true;
            }
            if (!hasBrass && ((class_3499.class_3501)actor.left).comp_1342().method_27852((class_2248)CPLBlocks.BRASS_CHUNK_LOADER.get())) {
                hasBrass = true;
            }
            if (!hasAndesite || !hasBrass) continue;
            break;
        }
        this.andesite = hasAndesite;
        this.brass = hasBrass;
    }

    private boolean canLoadChunks() {
        if (this.carriage.train.graph == null) {
            return false;
        }
        return this.andesite && (Boolean)CPLConfigs.server().andesite.enableTrain.get() != false || this.brass && (Boolean)CPLConfigs.server().brass.enableTrain.get() != false;
    }

    public class_2487 write() {
        class_2487 nbt = new class_2487();
        if (this.known) {
            nbt.method_10556("andesite", this.andesite);
            nbt.method_10556("brass", this.brass);
        }
        return nbt;
    }

    public static CarriageChunkLoader read(Carriage carriage, class_2487 nbt) {
        if (nbt.method_10545("andesite") && nbt.method_10545("brass")) {
            return new CarriageChunkLoader(carriage, true, nbt.method_10577("andesite"), nbt.method_10577("brass"));
        }
        return new CarriageChunkLoader(carriage, false, false, false);
    }
}

