/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.trains;

import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StationChunkLoader
implements ChunkLoader {
    private final GlobalStation station;
    public final Set<AttachedLoader> attachments = new HashSet<AttachedLoader>();
    private final Map<class_5321<class_1937>, Set<ChunkLoadManager.LoadedChunkPos>> reclaimedChunks = new HashMap<class_5321<class_1937>, Set<ChunkLoadManager.LoadedChunkPos>>();
    public final Set<ChunkLoadManager.LoadedChunkPos> forcedChunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
    private boolean registered = false;

    public StationChunkLoader(GlobalStation station) {
        this.station = station;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        return this.forcedChunks;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.STATION;
    }

    @Override
    public LoaderType getLoaderType() {
        for (AttachedLoader attachment : this.attachments) {
            if (attachment.type() != LoaderType.BRASS) continue;
            return LoaderType.BRASS;
        }
        return LoaderType.ANDESITE;
    }

    @Override
    @Nullable
    public Pair<class_2960, class_2338> getLocation() {
        return Pair.of((Object)((TrackNodeLocation)this.station.edgeLocation.getFirst()).dimension.method_29177(), (Object)class_2338.method_49638((class_2374)((TrackNodeLocation)this.station.edgeLocation.getFirst()).getLocation().method_1019(((TrackNodeLocation)this.station.edgeLocation.getSecond()).getLocation()).method_1021(0.5)));
    }

    @Override
    public void addToManager() {
        if (!this.registered) {
            ChunkLoader.super.addToManager();
            this.registered = true;
        }
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        if (preTrains) {
            return;
        }
        class_1937 level = ChunkLoadManager.tickLevel;
        if (level == null || level.method_8608()) {
            return;
        }
        this.addToManager();
        ChunkLoadManager.reclaimChunks(level, this.station.id, this.reclaimedChunks);
        if (this.attachments.isEmpty() || this.station.getPresentTrain() == null) {
            if (!this.forcedChunks.isEmpty()) {
                ChunkLoadManager.unforceAllChunks(level.method_8503(), this.station.id, this.forcedChunks);
            }
            return;
        }
        this.attachments.removeIf(a -> a.pos.method_19455((class_2382)this.station.blockEntityPos) > 1);
        HashSet<ChunkLoadManager.LoadedChunkPos> loadTargets = new HashSet<ChunkLoadManager.LoadedChunkPos>();
        for (AttachedLoader attachment : this.attachments) {
            if (!StationChunkLoader.isEnabledForStation(attachment.type())) continue;
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(this.station.blockEntityDimension.method_29177(), new class_1923(attachment.pos())));
        }
        ChunkLoadManager.updateForcedChunks(level.method_8503(), loadTargets, this.station.id, (int)((Integer)CPLConfigs.server().getFor((LoaderType)this.getLoaderType()).rangeOnStation.get()), this.forcedChunks);
    }

    public static boolean isEnabledForStation(LoaderType type) {
        return (Boolean)CPLConfigs.server().getFor((LoaderType)type).enableStation.get();
    }

    public void removeAttachment(class_2338 pos) {
        this.attachments.removeIf(t -> t.pos.equals((Object)pos));
    }

    public void addAttachment(LoaderType type, class_2338 pos) {
        this.removeAttachment(pos);
        this.attachments.add(new AttachedLoader(type, pos));
    }

    public void onRemove() {
        ChunkLoadManager.enqueueUnforceAll(this.station.id, this.forcedChunks);
        this.removeFromManager();
    }

    public class_2487 write() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("Attachments", (class_2520)NBTHelper.writeCompoundList(this.attachments, AttachedLoader::write));
        return nbt;
    }

    public static StationChunkLoader read(GlobalStation station, class_2487 nbt) {
        StationChunkLoader loader = new StationChunkLoader(station);
        loader.attachments.clear();
        loader.attachments.addAll(NBTHelper.readCompoundList((class_2499)nbt.method_10554("Attachments", 10), AttachedLoader::read));
        return loader;
    }

    public record AttachedLoader(LoaderType type, class_2338 pos) {
        public class_2487 write() {
            class_2487 nbt = new class_2487();
            NBTHelper.writeEnum((class_2487)nbt, (String)"Type", (Enum)this.type);
            nbt.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)this.pos));
            return nbt;
        }

        public static AttachedLoader read(class_2487 nbt) {
            return new AttachedLoader((LoaderType)NBTHelper.readEnum((class_2487)nbt, (String)"Type", LoaderType.class), class_2512.method_10691((class_2487)nbt.method_10562("Pos")));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AttachedLoader)) {
                return false;
            }
            AttachedLoader loader = (AttachedLoader)obj;
            if (this.type != loader.type) {
                return false;
            }
            return Objects.equals(this.pos, loader.pos);
        }
    }
}

