/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.trains;

import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.hlysine.create_power_loader.content.trains.CarriageChunkLoader;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class TrainChunkLoader
implements ChunkLoader {
    private final Train train;
    public final List<CarriageChunkLoader> carriageLoaders = new LinkedList<CarriageChunkLoader>();
    private final Map<class_5321<class_1937>, Set<ChunkLoadManager.LoadedChunkPos>> reclaimedChunks = new HashMap<class_5321<class_1937>, Set<ChunkLoadManager.LoadedChunkPos>>();
    private boolean registered = false;

    public TrainChunkLoader(Train train) {
        this.train = train;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        HashSet<ChunkLoadManager.LoadedChunkPos> allForced = new HashSet<ChunkLoadManager.LoadedChunkPos>();
        for (CarriageChunkLoader loader : this.carriageLoaders) {
            allForced.addAll(loader.getForcedChunks());
        }
        return allForced;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.TRAIN;
    }

    @Override
    public LoaderType getLoaderType() {
        for (CarriageChunkLoader carriageLoader : this.carriageLoaders) {
            if (carriageLoader.getLoaderType() != LoaderType.BRASS) continue;
            return LoaderType.BRASS;
        }
        return LoaderType.ANDESITE;
    }

    @Override
    public Pair<class_2960, class_2338> getLocation() {
        if (this.train.graph == null) {
            return null;
        }
        return this.train.carriages.stream().findFirst().map(carriage -> Pair.of((Object)carriage.leadingBogey().trailing().node1.getLocation().getDimension().method_29177(), (Object)class_2338.method_49638((class_2374)carriage.leadingBogey().trailing().getPosition(this.train.graph)))).orElse(null);
    }

    @Override
    public void addToManager() {
        if (!this.registered) {
            ChunkLoader.super.addToManager();
            this.registered = true;
        }
    }

    public void tick(class_1937 level) {
        if (level.method_8608()) {
            return;
        }
        this.addToManager();
        if (this.carriageLoaders.size() != this.train.carriages.size()) {
            LinkedList<CarriageChunkLoader> newLoaders = new LinkedList<CarriageChunkLoader>();
            for (Carriage carriage : this.train.carriages) {
                CarriageChunkLoader loader = this.carriageLoaders.stream().filter(x -> x.carriage == carriage).findFirst().orElseGet(() -> new CarriageChunkLoader(carriage, false, false, false));
                newLoaders.add(loader);
            }
            this.carriageLoaders.clear();
            this.carriageLoaders.addAll(newLoaders);
        }
        ChunkLoadManager.reclaimChunks(level, this.train.id, this.reclaimedChunks);
        for (CarriageChunkLoader loader : this.carriageLoaders) {
            loader.tick(level);
        }
    }

    public void onRemove() {
        for (CarriageChunkLoader loader : this.carriageLoaders) {
            loader.onRemove();
        }
        this.removeFromManager();
    }

    public class_2487 write() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("CarriageLoaders", (class_2520)NBTHelper.writeCompoundList(this.carriageLoaders, CarriageChunkLoader::write));
        return nbt;
    }

    public static TrainChunkLoader read(Train train, class_2487 nbt) {
        TrainChunkLoader loader = new TrainChunkLoader(train);
        class_2499 list = nbt.method_10554("CarriageLoaders", 10);
        if (list.size() == train.carriages.size()) {
            for (int i = 0; i < list.size(); ++i) {
                class_2487 tag = (class_2487)list.method_10534(i);
                loader.carriageLoaders.add(CarriageChunkLoader.read((Carriage)train.carriages.get(i), tag));
            }
        }
        return loader;
    }
}

