/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuide;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.camera.infrastructure.ShutterSpeed;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.CameraSetCompositionGuideC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetFlashModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetSelfieModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetShutterSpeedC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetZoomC2SP;
import io.github.mortuusars.exposure.network.packet.server.DeactivateCameraC2SP;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;

public class CameraClient {
    public static Optional<Camera<?>> getCamera() {
        return Camera.getCamera((class_1657)class_310.method_1551().field_1724);
    }

    public static void deactivate(class_1657 player) {
        Preconditions.checkState((boolean)player.method_37908().field_9236, (Object)"Can only be called clientside.");
        Camera.getCamera(player).ifPresent(camera -> camera.deactivate(player));
        Packets.sendToServer(new DeactivateCameraC2SP());
    }

    public static void setZoom(double focalLength) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setZoom((class_1799)stack, focalLength));
            Packets.sendToServer(new CameraSetZoomC2SP(focalLength));
        });
    }

    public static void setShutterSpeed(ShutterSpeed shutterSpeed) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setShutterSpeed((class_1799)stack, shutterSpeed));
            Packets.sendToServer(new CameraSetShutterSpeedC2SP(shutterSpeed));
        });
    }

    public static void setFlashMode(FlashMode flashMode) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setFlashMode((class_1799)stack, flashMode));
            Packets.sendToServer(new CameraSetFlashModeC2SP(flashMode));
        });
    }

    public static void setCompositionGuide(CompositionGuide guide) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setCompositionGuide((class_1799)stack, guide));
            Packets.sendToServer(new CameraSetCompositionGuideC2SP(guide));
        });
    }

    public static void setSelfieMode(boolean inSelfieMode) {
        CameraClient.getCamera().ifPresent(c -> {
            c.apply((item, stack) -> item.setSelfieModeWithEffects((class_1657)class_310.method_1551().field_1724, (class_1799)stack, inSelfieMode));
            Packets.sendToServer(new CameraSetSelfieModeC2SP(inSelfieMode));
        });
    }
}

