/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.command.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.command.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ShowExposureS2CP;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ShowCommand {
    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"show").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"latest").executes(context -> ShowCommand.latest((class_2168)context.getSource(), false))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.latest((class_2168)context.getSource(), true))))).then(class_2170.method_9247((String)"id").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ShowCommand.exposureId((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), false))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.exposureId((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), true)))))).then(class_2170.method_9247((String)"texture").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)new TextureLocationArgument()).executes(context -> ShowCommand.texture((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"path"), false))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.texture((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"path"), true)))));
    }

    private static int latest(class_2168 stack, boolean negative) {
        class_3222 player = stack.method_44023();
        if (player == null) {
            stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        Packets.sendToClient(ShowExposureS2CP.latest(negative), player);
        return 0;
    }

    private static int exposureId(class_2168 stack, String id, boolean negative) {
        class_3222 player = stack.method_44023();
        if (player == null) {
            stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        Optional<ExposureSavedData> exposureData = ExposureServer.getExposureStorage().getOrQuery(id);
        if (exposureData.isEmpty()) {
            stack.method_9213((class_2561)class_2561.method_43469((String)"command.exposure.show.error.not_found", (Object[])new Object[]{id}));
            return 0;
        }
        ExposureServer.getExposureSender().sendTo((class_1657)player, id, exposureData.get());
        Packets.sendToClient(ShowExposureS2CP.id(id, negative), player);
        return 0;
    }

    private static int texture(class_2168 stack, class_2960 path, boolean negative) {
        class_3222 player = stack.method_44023();
        if (player == null) {
            stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        Packets.sendToClient(ShowExposureS2CP.texture(path.toString(), negative), player);
        return 0;
    }
}

