/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.CameraClient;
import io.github.mortuusars.exposure.gui.screen.element.IElementWithTooltip;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.FilmRollItem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class FrameCounterButton
extends class_344
implements IElementWithTooltip {
    private final int secondaryFontColor = Config.Client.getSecondaryFontColor();
    private final int mainFontColor = Config.Client.getMainFontColor();

    public FrameCounterButton(class_437 screen, int x, int y, int width, int height, int u, int v, class_2960 texture) {
        super(x, y, width, height, u, v, height, texture, 256, 256, button -> {}, (class_2561)class_2561.method_43473());
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, pPartialTick);
    }

    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, pPartialTick);
        Camera<?> camera = CameraClient.getCamera().orElseThrow();
        String text = ((CameraItem)((Object)camera.get().getItem())).getFilm(camera.get().getStack()).map(film -> {
            int exposedFrames = ((FilmRollItem)film.getItem()).getExposedFrames(film.getStack()).size();
            int totalFrames = ((FilmRollItem)film.getItem()).getMaxFrameCount(film.getStack());
            return exposedFrames + "/" + totalFrames;
        }).orElse("-");
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        int xPos = 15 + (27 - textWidth) / 2;
        guiGraphics.method_51433(font, text, this.method_46426() + xPos, this.method_46427() + 8, this.secondaryFontColor, false);
        guiGraphics.method_51433(font, text, this.method_46426() + xPos, this.method_46427() + 7, this.mainFontColor, false);
    }

    @Override
    public void renderToolTip(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        ArrayList<class_5250> components = new ArrayList<class_5250>();
        components.add(class_2561.method_43471((String)"gui.exposure.viewfinder.film_frame_counter.tooltip"));
        Camera<?> camera = CameraClient.getCamera().orElseThrow();
        if (((CameraItem)((Object)camera.get().getItem())).getFilm(camera.get().getStack()).isEmpty()) {
            components.add(class_2561.method_43471((String)"gui.exposure.viewfinder.film_frame_counter.tooltip.no_film").method_27696(class_2583.field_24360.method_36139(14508887)));
        }
        guiGraphics.method_51437(class_310.method_1551().field_1772, components, Optional.empty(), mouseX, mouseY);
    }
}

