/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.handler;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.CaptureManager;
import io.github.mortuusars.exposure.camera.capture.CapturedFramesHistory;
import io.github.mortuusars.exposure.camera.capture.FileCapture;
import io.github.mortuusars.exposure.camera.capture.ScreenshotCapture;
import io.github.mortuusars.exposure.camera.capture.component.BaseComponent;
import io.github.mortuusars.exposure.camera.capture.component.ExposureStorageSaveComponent;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.capture.converter.DitheringColorConverter;
import io.github.mortuusars.exposure.camera.capture.converter.SimpleColorConverter;
import io.github.mortuusars.exposure.client.ComplicatedChromaticFinalizer;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.data.storage.ClientsideExposureExporter;
import io.github.mortuusars.exposure.gui.screen.NegativeExposureScreen;
import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.network.packet.client.ApplyShaderS2CP;
import io.github.mortuusars.exposure.network.packet.client.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.ExposureChangedS2CP;
import io.github.mortuusars.exposure.network.packet.client.OnFrameAddedS2CP;
import io.github.mortuusars.exposure.network.packet.client.ShowExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.StartExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.SyncLensesS2CP;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.ClientsideWorldNameGetter;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ClientPacketsHandler {
    public static void applyShader(ApplyShaderS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> {
            if (packet.shaderLocation().method_12832().equals("none")) {
                class_310.method_1551().field_1773.method_3207();
            } else {
                class_310.method_1551().field_1773.method_3168(packet.shaderLocation());
            }
        });
    }

    public static void exposeScreenshot(int size) {
        Preconditions.checkState((size > 0 ? 1 : 0) != 0, (Object)(size + " size is invalid. Should be larger than 0."));
        if (size == Integer.MAX_VALUE) {
            size = Math.min(class_310.method_1551().method_22683().method_4489(), class_310.method_1551().method_22683().method_4506());
        }
        int finalSize = size;
        ClientPacketsHandler.executeOnMainThread(() -> {
            final String filename = class_156.method_44893();
            class_2487 frameData = new class_2487();
            frameData.method_10582("Id", filename);
            Capture capture = new ScreenshotCapture().setSize(finalSize).cropFactor(1.0f).setComponents(new BaseComponent(true), (ICaptureComponent)((ClientsideExposureExporter)((ClientsideExposureExporter)new ClientsideExposureExporter(filename).organizeByWorld((Boolean)Config.Client.EXPOSURE_SAVING_LEVEL_SUBFOLDER.get(), ClientsideWorldNameGetter::getWorldName)).withModifier(ExposurePixelModifiers.EMPTY)).withSize(ExposureSize.X1), new ICaptureComponent(){

                @Override
                public void end(Capture capture) {
                    Exposure.LOGGER.info("Saved exposure screenshot: {}", (Object)filename);
                }
            }).setConverter(new DitheringColorConverter());
            CaptureManager.enqueue(capture);
        });
    }

    public static void loadExposure(String exposureId, String path, int size, boolean dither) {
        class_746 player = class_310.method_1551().field_1724;
        if (class_3544.method_15438((String)exposureId)) {
            if (player == null) {
                throw new IllegalStateException("Cannot load exposure: path is null or empty and player is null.");
            }
            exposureId = player.method_5477().getString() + player.method_37908().method_8510();
        }
        String finalExposureId = exposureId;
        new Thread(() -> {
            Capture capture = new FileCapture(path, error -> {
                if (player != null) {
                    player.method_7353((class_2561)error.getTechnicalTranslation().method_27692(class_124.field_1061), false);
                }
            }).setSize(size).cropFactor(1.0f).setComponents(new ExposureStorageSaveComponent(finalExposureId, true)).setConverter(dither ? new DitheringColorConverter() : new SimpleColorConverter());
            CaptureManager.enqueue(capture);
            class_2487 frameData = new class_2487();
            frameData.method_10582("Id", finalExposureId);
            CapturedFramesHistory.add(frameData);
            Exposure.LOGGER.info("Loaded exposure from file '{}' with Id: '{}'.", (Object)path, (Object)finalExposureId);
            Objects.requireNonNull(class_310.method_1551().field_1724).method_7353((class_2561)class_2561.method_43469((String)"command.exposure.load_from_file.success", (Object[])new Object[]{finalExposureId}).method_27692(class_124.field_1060), false);
        }).start();
    }

    public static void startExposure(StartExposureS2CP packet) {
        class_310.method_1551().execute(() -> {
            CameraItem cameraItem;
            @Nullable class_746 player = class_310.method_1551().field_1724;
            Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Player cannot be null.");
            class_1799 itemInHand = player.method_5998(packet.activeHand());
            class_1792 patt0$temp = itemInHand.method_7909();
            if (!(patt0$temp instanceof CameraItem) || !(cameraItem = (CameraItem)patt0$temp).isActive(itemInHand)) {
                throw new IllegalStateException("Player should have active Camera in hand. " + String.valueOf(itemInHand));
            }
            cameraItem.exposeFrameClientside((class_1657)player, packet.activeHand(), packet.exposureId(), packet.flashHasFired(), packet.lightLevel());
        });
    }

    public static void showExposure(ShowExposureS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> {
            class_437 screen;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                Exposure.LOGGER.error("Cannot show exposures. Player is null.");
                return;
            }
            boolean negative = packet.negative();
            if (packet.latest()) {
                screen = ClientPacketsHandler.createLatestScreen((class_1657)player, negative);
            } else if (negative) {
                Either idOrTexture = packet.isTexture() ? Either.right((Object)new class_2960(packet.idOrPath())) : Either.left((Object)packet.idOrPath());
                screen = new NegativeExposureScreen(List.of(idOrTexture));
            } else {
                class_1799 stack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
                class_2487 tag = new class_2487();
                tag.method_10582(packet.isTexture() ? "Texture" : "Id", packet.idOrPath());
                stack.method_7980(tag);
                screen = new PhotographScreen(List.of(new ItemAndStack(stack)));
            }
            if (screen != null) {
                class_310.method_1551().method_1507(screen);
            }
        });
    }

    @Nullable
    private static class_437 createLatestScreen(class_1657 player, boolean negative) {
        List<class_2487> latestFrames = CapturedFramesHistory.get().stream().filter(frame -> !frame.method_10558("Id").isEmpty()).toList();
        if (latestFrames.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"command.exposure.show.latest.error.no_exposures"), false);
            return null;
        }
        if (negative) {
            ArrayList<Either<String, class_2960>> exposures = new ArrayList<Either<String, class_2960>>();
            for (class_2487 frame2 : latestFrames) {
                String exposureId = frame2.method_10558("Id");
                exposures.add((Either<String, class_2960>)Either.left((Object)exposureId));
            }
            return new NegativeExposureScreen(exposures);
        }
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>();
        for (class_2487 frame3 : latestFrames) {
            class_1799 stack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
            stack.method_7980(frame3);
            photographs.add(new ItemAndStack(stack));
        }
        return new PhotographScreen(photographs);
    }

    public static void clearRenderingCache() {
        ClientPacketsHandler.executeOnMainThread(() -> ExposureClient.getExposureRenderer().clearData());
    }

    public static void syncLenses(SyncLensesS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> Lenses.reload(packet.lenses()));
    }

    public static void waitForExposureChange(WaitForExposureChangeS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> ExposureClient.getExposureStorage().putOnWaitingList(packet.exposureId()));
    }

    public static void onExposureChanged(ExposureChangedS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> {
            ExposureClient.getExposureStorage().remove(packet.exposureId());
            ExposureClient.getExposureRenderer().clearDataSingle(packet.exposureId(), true);
        });
    }

    public static void onFrameAdded(OnFrameAddedS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> CapturedFramesHistory.add(packet.frame()));
    }

    public static void createChromaticExposure(CreateChromaticExposureS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> ComplicatedChromaticFinalizer.finalizeChromatic(packet.red(), packet.green(), packet.blue(), packet.exposureId()));
    }

    private static void executeOnMainThread(Runnable runnable) {
        class_310.method_1551().execute(runnable);
    }
}

