/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BlackboardItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CreateCompat;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class BlackboardDisplayTarget
extends DisplayTarget {
    private static final Pattern PATTERN = Pattern.compile("\\((\\d\\d?),(\\d\\d?)\\)->(\\S+)");

    public void acceptText(int line, List<class_5250> text, DisplayLinkContext context) {
        class_2586 te = context.getTargetBlockEntity();
        if (te instanceof BlackboardBlockTile) {
            BlackboardBlockTile tile = (BlackboardBlockTile)te;
            if (text.size() > 0 && !tile.isWaxed()) {
                class_2586 source = context.getSourceBlockEntity();
                if (!this.parseText(text.get(0).getString(), tile)) {
                    class_1799 copyStack = CreateCompat.getDisplayedItem(context, source, i -> i.method_7909() instanceof BlackboardItem);
                    if (!copyStack.method_7960() && BlackboardDisplayTarget.copyBlackboard(line, context, te, tile, copyStack)) {
                        return;
                    }
                    long[] pixels = CommonConfigs.Building.BLACKBOARD_COLOR.get() != false ? BlackboardBlockTile.unpackPixelsFromString(text.get(0).getString()) : BlackboardBlockTile.unpackPixelsFromStringWhiteOnly(text.get(0).getString());
                    tile.setPixels(BlackboardBlockTile.unpackPixels(pixels));
                }
                context.level().method_8413(context.getTargetPos(), te.method_11010(), te.method_11010(), 2);
                BlackboardDisplayTarget.reserve((int)line, (class_2586)te, (DisplayLinkContext)context);
            }
        }
    }

    private boolean parseText(String string, BlackboardBlockTile tile) {
        Matcher m = PATTERN.matcher(string);
        if (m.matches()) {
            int x = Integer.parseInt(m.group(1));
            int y = Integer.parseInt(m.group(2));
            class_1767 dye = class_1767.method_7793((String)m.group(3), null);
            if (x >= 0 && x <= 15 && y >= 0 && y <= 15 && dye != null) {
                if (dye != class_1767.field_7952 && dye != class_1767.field_7963 && !CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue()) {
                    return false;
                }
                tile.setPixel(x, y, BlackboardBlock.colorToByte(dye));
                return true;
            }
        }
        return false;
    }

    private static boolean copyBlackboard(int line, DisplayLinkContext context, class_2586 te, BlackboardBlockTile tile, class_1799 stack) {
        class_2487 cmp = stack.method_7941("BlockEntityTag");
        if (cmp != null && cmp.method_10545("Pixels")) {
            tile.setPixels(BlackboardBlockTile.unpackPixels(cmp.method_10565("Pixels")));
            context.level().method_8413(context.getTargetPos(), te.method_11010(), te.method_11010(), 2);
            BlackboardDisplayTarget.reserve((int)line, (class_2586)te, (DisplayLinkContext)context);
            return true;
        }
        return false;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        return new DisplayTargetStats(1, 32, (DisplayTarget)this);
    }
}

