/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.source;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class StationSummaryDisplaySource
extends DisplaySource {
    protected static final class_5250 UNPREDICTABLE = Components.literal(" ~ ");
    protected static final List<class_5250> EMPTY_ENTRY_4 = ImmutableList.of((Object)WHITESPACE, (Object)Components.literal(" . "), (Object)WHITESPACE, (Object)WHITESPACE);
    protected static final List<class_5250> EMPTY_ENTRY_5 = ImmutableList.of((Object)WHITESPACE, (Object)Components.literal(" . "), (Object)WHITESPACE, (Object)WHITESPACE, (Object)WHITESPACE);

    @Override
    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        return EMPTY;
    }

    @Override
    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        String filter = context.sourceConfig().method_10558("Filter");
        boolean hasPlatform = filter.contains("*");
        ArrayList<List<class_5250>> list = new ArrayList<List<class_5250>>();
        GlobalTrainDisplayData.prepare(filter, stats.maxRows()).forEach(prediction -> {
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            if (prediction.ticks == -1 || prediction.ticks >= 11700) {
                lines.add(WHITESPACE);
                lines.add(UNPREDICTABLE);
            } else if (prediction.ticks < 200) {
                lines.add(WHITESPACE);
                lines.add(Lang.translateDirect("display_source.station_summary.now", new Object[0]));
            } else {
                int min = prediction.ticks / 1200;
                int sec = prediction.ticks / 20 % 60;
                if ((sec = class_3532.method_15386((float)((float)sec / 15.0f)) * 15) == 60) {
                    ++min;
                    sec = 0;
                }
                lines.add(min > 0 ? Components.literal(String.valueOf(min)) : WHITESPACE);
                lines.add(min > 0 ? Lang.translateDirect("display_source.station_summary.minutes", new Object[0]) : Lang.translateDirect("display_source.station_summary.seconds", sec));
            }
            lines.add(prediction.train.name.method_27661());
            lines.add(prediction.scheduleTitle);
            if (!hasPlatform) {
                list.add(lines);
                return;
            }
            String platform = prediction.destination;
            for (String string : filter.split("\\*")) {
                if (string.isEmpty()) continue;
                platform = platform.replace(string, "");
            }
            platform = platform.replace("*", "?");
            lines.add(Components.literal(platform.trim()));
            list.add(lines);
        });
        if (list.size() > 0) {
            context.blockEntity().award(AllAdvancements.DISPLAY_BOARD);
        }
        int toPad = stats.maxRows() - list.size();
        for (int padding = 0; padding < toPad; ++padding) {
            list.add(hasPlatform ? EMPTY_ENTRY_5 : EMPTY_ENTRY_4);
        }
        return list;
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        class_2487 conf = context.sourceConfig();
        int columnWidth = conf.method_10550("NameColumn");
        int columnWidth2 = conf.method_10550("PlatformColumn");
        boolean hasPlatform = conf.method_10558("Filter").contains("*");
        String layoutName = "StationSummary" + columnWidth + hasPlatform + columnWidth2;
        if (layout.isLayout(layoutName)) {
            return;
        }
        ArrayList<FlapDisplaySection> list = new ArrayList<FlapDisplaySection>();
        int timeWidth = 20;
        float gapSize = 8.0f;
        float platformWidth = (float)columnWidth2 * 7.0f;
        FlapDisplaySection minutes = new FlapDisplaySection(7.0f, "numeric", false, false);
        FlapDisplaySection time = new FlapDisplaySection(timeWidth, "arrival_time", true, true);
        float totalSize = (float)flapDisplay.xSize * 32.0f - 4.0f - gapSize * 2.0f;
        totalSize = totalSize - (float)timeWidth - 7.0f;
        platformWidth = Math.min(platformWidth, totalSize - gapSize);
        platformWidth = (float)((int)(platformWidth / 7.0f)) * 7.0f;
        if (hasPlatform) {
            totalSize = totalSize - gapSize - platformWidth;
        }
        if (platformWidth == 0.0f && hasPlatform) {
            totalSize += gapSize;
        }
        int trainNameWidth = (int)((float)columnWidth / 100.0f * totalSize / 7.0f);
        int destinationWidth = Math.round((1.0f - (float)columnWidth / 100.0f) * totalSize / 7.0f);
        FlapDisplaySection trainName = new FlapDisplaySection((float)trainNameWidth * 7.0f, "alphabet", false, trainNameWidth > 0);
        FlapDisplaySection destination = new FlapDisplaySection((float)destinationWidth * 7.0f, "alphabet", false, hasPlatform && destinationWidth > 0 && platformWidth > 0.0f);
        FlapDisplaySection platform = new FlapDisplaySection(platformWidth, "numeric", false, false).rightAligned();
        list.add(minutes);
        list.add(time);
        list.add(trainName);
        list.add(destination);
        if (hasPlatform) {
            list.add(platform);
        }
        layout.configure(layoutName, list);
    }

    @Override
    protected String getTranslationKey() {
        return "station_summary";
    }

    @Override
    public void populateData(DisplayLinkContext context) {
        class_2487 conf = context.sourceConfig();
        if (!conf.method_10545("PlatformColumn")) {
            conf.method_10569("PlatformColumn", 3);
        }
        if (!conf.method_10545("NameColumn")) {
            conf.method_10569("NameColumn", 50);
        }
        if (conf.method_10545("Filter")) {
            return;
        }
        class_2586 class_25862 = context.getSourceBlockEntity();
        if (!(class_25862 instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity stationBe = (StationBlockEntity)class_25862;
        GlobalStation station = stationBe.getStation();
        if (station == null) {
            return;
        }
        conf.method_10582("Filter", station.name);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        if (isFirstLine) {
            builder.addTextInput(0, 137, (e, t) -> {
                e.method_1852("");
                t.withTooltip((List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("display_source.station_summary.filter", new Object[0]).method_27694(s -> s.method_36139(5476833)), (Object)Lang.translateDirect("gui.schedule.lmb_edit", new Object[0]).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})));
            }, "Filter");
            return;
        }
        builder.addScrollInput(0, 32, (si, l) -> {
            si.titled(Lang.translateDirect("display_source.station_summary.train_name_column", new Object[0])).withRange(0, 73).withShiftStep(12);
            si.setState(50);
            l.withSuffix("%");
        }, "NameColumn");
        builder.addScrollInput(36, 22, (si, l) -> {
            si.titled(Lang.translateDirect("display_source.station_summary.platform_column", new Object[0])).withRange(0, 16).withShiftStep(4);
            si.setState(3);
        }, "PlatformColumn");
    }
}

