/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.workarounds.context_creation;

import net.caffeinemc.mods.sodium.client.compatibility.checks.ModuleScanner;
import net.caffeinemc.mods.sodium.client.compatibility.checks.PostLaunchChecks;
import net.caffeinemc.mods.sodium.client.compatibility.environment.GlContextInfo;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaWorkarounds;
import net.caffeinemc.mods.sodium.client.platform.NativeWindowHandle;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_323;
import net.minecraft.class_3678;
import net.minecraft.class_543;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1041.class})
public class WindowMixin {
    @Shadow
    @Final
    private static Logger field_5178;
    @Unique
    private long wglPrevContext = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"<init>(Lnet/minecraft/class_3678;Lnet/minecraft/class_323;Lnet/minecraft/class_543;Ljava/lang/String;Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateWindow(IILjava/lang/CharSequence;JJ)J"), expect=0, require=0)
    private long wrapGlfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        NvidiaWorkarounds.applyEnvironmentChanges();
        try {
            long l = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
            return l;
        }
        finally {
            NvidiaWorkarounds.undoEnvironmentChanges();
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/class_3678;Lnet/minecraft/class_323;Lnet/minecraft/class_543;Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL;createCapabilities()Lorg/lwjgl/opengl/GLCapabilities;", shift=At.Shift.AFTER)})
    private void postWindowCreated(class_3678 eventHandler, class_323 monitorTracker, class_543 settings, String videoMode, String title, CallbackInfo ci) {
        GlContextInfo context = GlContextInfo.create();
        field_5178.info("OpenGL Vendor: {}", (Object)context.vendor());
        field_5178.info("OpenGL Renderer: {}", (Object)context.renderer());
        field_5178.info("OpenGL Version: {}", (Object)context.version());
        this.wglPrevContext = class_156.method_668() == class_156.class_158.field_1133 ? WGL.wglGetCurrentContext() : 0L;
        PostLaunchChecks.onContextInitialized((NativeWindowHandle)((Object)this), context);
        ModuleScanner.checkModules((NativeWindowHandle)((Object)this));
    }

    @Inject(method={"method_15998()V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;flipFrame(J)V", shift=At.Shift.AFTER)})
    private void preSwapBuffers(CallbackInfo ci) {
        if (this.wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (this.wglPrevContext == context) {
            return;
        }
        field_5178.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        ModuleScanner.checkModules((NativeWindowHandle)((Object)this));
        this.wglPrevContext = context;
    }
}

