/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.WaterSensitiveEntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@Deprecated(forRemoval=true)
@ApiStatus.ScheduledForRemoval(inVersion="4.0.0+1.21.4")
public final class DynamicLightHandlers {
    private static final Map<class_1299<?>, DynamicLightHandler<?>> HANDLERS = new HashMap();
    private static final EntityLuminance.Type DUMMY_RETROFIT_TYPE = new EntityLuminance.Type(LambDynLightsConstants.id("dummy/old_dynamic_light_handlers"), null);

    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    @ApiStatus.Internal
    public static void registerDefaultHandlers() {
        LambDynLights.get().entityLightSourceManager().onRegisterEvent().register(context -> HANDLERS.forEach((type, handler) -> {
            DynamicLightHandler actualHandler = handler;
            context.register(type, new EntityLuminance[]{new WaterSensitiveEntityLuminance(List.of(DynamicLightHandlers.retrofitHandler(actualHandler, false)), List.of(DynamicLightHandlers.retrofitHandler(actualHandler, true)))});
        }));
    }

    public static <T extends class_1297> void registerDynamicLightHandler(class_1299<T> type, DynamicLightHandler<T> handler) {
        HANDLERS.compute(type, (ignored, existing) -> {
            if (existing != null) {
                return DynamicLightHandler.makeHandler(entity -> Math.max(existing.getLuminance(entity), handler.getLuminance(entity)), entity -> existing.isWaterSensitive(entity) || handler.isWaterSensitive(entity));
            }
            return handler;
        });
    }

    @Nullable
    public static <T extends class_1297> DynamicLightHandler<T> getDynamicLightHandler(class_1299<T> type) {
        return HANDLERS.get(type);
    }

    public static <T extends class_1297> boolean canLightUp(T entity) {
        return DynamicLightingEngine.canLightUp(entity);
    }

    public static <T extends class_1297> int getLuminanceFrom(T entity) {
        return LambDynLights.getLuminanceFrom(entity);
    }

    private static EntityLuminance retrofitHandler(final DynamicLightHandler<class_1297> handler, final boolean inWater) {
        return new EntityLuminance(){

            @NotNull
            public EntityLuminance.Type type() {
                return DUMMY_RETROFIT_TYPE;
            }

            public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
                if (handler.isWaterSensitive(entity) && inWater) {
                    return 0;
                }
                return handler.getLuminance(entity);
            }
        };
    }
}

