/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.yumi.commons.Unit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public abstract class LightSourceLoader<L>
implements IdentifiableResourceReloadListener {
    protected static final String SILENCE_ERROR_KEY = "silence_error";
    private final class_310 client = class_310.method_1551();
    protected final List<LoadedLightSourceResource> loadedLightSources = new ArrayList<LoadedLightSourceResource>();
    protected final List<L> lightSources = new ArrayList<L>();

    protected abstract Logger getLogger();

    protected abstract String getResourcePath();

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.load(resourceManager);
            return Unit.INSTANCE;
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(reloadState -> {
            if (this.client.field_1687 != null) {
                this.apply(this.client.field_1687.method_30349());
            }
        }, applyExecutor);
    }

    protected void load(class_3300 resourceManager) {
        this.loadedLightSources.clear();
        resourceManager.method_14488("dynamiclights/" + this.getResourcePath(), path -> path.method_12832().endsWith(".json")).forEach(this::load);
    }

    public void apply(class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        this.lightSources.clear();
        this.loadedLightSources.forEach(data -> this.apply((DynamicOps<JsonElement>)ops, (LoadedLightSourceResource)data));
    }

    protected void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            if (!rawJson.isJsonObject()) {
                LambDynLights.warn(this.getLogger(), "Failed to load {} light source \"{}\". Expected JSON object in file.", this.getResourcePath(), id);
                return;
            }
            JsonObject json = rawJson.getAsJsonObject();
            boolean silentError = false;
            if (json.has(SILENCE_ERROR_KEY)) {
                silentError = json.get(SILENCE_ERROR_KEY).getAsBoolean();
                json.remove(SILENCE_ERROR_KEY);
            }
            this.loadedLightSources.add(new LoadedLightSourceResource(id, json, silentError));
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.warn(this.getLogger(), "Failed to load {} light source \"{}\".", this.getResourcePath(), id, e);
        }
    }

    protected abstract void apply(DynamicOps<JsonElement> var1, LoadedLightSourceResource var2);
}

