/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.api.item.ItemLuminance;
import dev.lambdaurora.lambdynlights.api.predicate.ItemPredicate;
import dev.lambdaurora.lambdynlights.resource.LightSourceLoader;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.yumi.commons.Either;
import dev.yumi.commons.event.Event;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemLightSources
extends LightSourceLoader<ItemLightSource>
implements ItemLightSourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|ItemLightSources");
    public static final class_2960 RESOURCE_RELOADER_ID = LambDynLightsConstants.id("item_dynamic_lights");
    private final Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent = LambDynLights.EVENT_MANAGER.create(ItemLightSourceManager.OnRegister.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public class_2960 getFabricId() {
        return RESOURCE_RELOADER_ID;
    }

    @Override
    protected String getResourcePath() {
        return "item";
    }

    @Override
    public void apply(final class_5455 registryAccess) {
        super.apply(registryAccess);
        this.onRegisterEvent.invoker().onRegister(new ItemLightSourceManager.RegisterContext(){

            @NotNull
            public class_5455 registryAccess() {
                return registryAccess;
            }

            public void register(@NotNull ItemLightSource itemLightSource) {
                ItemLightSources.this.lightSources.add(itemLightSource);
            }
        });
    }

    @Override
    protected void apply(DynamicOps<JsonElement> ops, LoadedLightSourceResource loadedData) {
        this.attemptLoadLegacy(loadedData).fold(Function.identity(), legacyError -> {
            DataResult loaded = ItemLightSource.CODEC.parse(ops, (Object)loadedData.data());
            if (!loadedData.silenceError() || LambDynLightsConstants.FORCE_LOG_ERRORS) {
                loaded.error().ifPresent(error -> {
                    LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\" due to error: {}", loadedData.id(), error.message());
                    LambDynLights.warn(LOGGER, "Also failed to load item light source \"{}\" in legacy mode due to error: {}", loadedData.id(), legacyError);
                });
            }
            return loaded.result();
        }).ifPresent(this.lightSources::add);
    }

    @NotNull
    private Either<Optional<ItemLightSource>, String> attemptLoadLegacy(LoadedLightSourceResource loadedData) {
        JsonPrimitive luminanceElement;
        if (!loadedData.data().has("item") || !loadedData.data().has("luminance")) {
            return Either.right("missing required fields (item, luminance).");
        }
        class_2960 affectId = new class_2960(loadedData.data().get("item").getAsString());
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(affectId);
        if (item == class_1802.field_8162) {
            return Either.left(Optional.empty());
        }
        boolean waterSensitive = false;
        if (loadedData.data().has("water_sensitive")) {
            waterSensitive = loadedData.data().get("water_sensitive").getAsBoolean();
        }
        if ((luminanceElement = loadedData.data().get("luminance").getAsJsonPrimitive()).isNumber()) {
            return Either.left(Optional.of(new ItemLightSource(ItemPredicate.Builder.item().of(new class_1935[]{item}).build(), (ItemLuminance)new ItemLuminance.Value(luminanceElement.getAsInt()), waterSensitive)));
        }
        if (luminanceElement.isString()) {
            class_2248 block;
            String luminanceStr = luminanceElement.getAsString();
            if (luminanceStr.equals("block")) {
                return Either.left(Optional.of(new ItemLightSource(ItemPredicate.Builder.item().of(new class_1935[]{item}).build(), (ItemLuminance)ItemLuminance.BlockSelf.INSTANCE, waterSensitive)));
            }
            class_2960 blockId = class_2960.method_12829((String)luminanceStr);
            if (blockId != null && (block = (class_2248)class_7923.field_41175.method_10223(blockId)) != class_2246.field_10124) {
                return Either.left(Optional.of(new ItemLightSource(ItemPredicate.Builder.item().of(new class_1935[]{item}).build(), (ItemLuminance)new ItemLuminance.BlockReference(block), waterSensitive)));
            }
        } else {
            return Either.right("\"luminance\" field value isn't string or integer.");
        }
        return Either.left(Optional.empty());
    }

    @NotNull
    public Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent() {
        return this.onRegisterEvent;
    }

    public int getLuminance(@NotNull class_1799 stack, boolean submergedInWater) {
        boolean shouldCareAboutWater = submergedInWater && (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get() != false;
        int luminance = 0;
        boolean matchedAny = false;
        for (ItemLightSource data : this.lightSources) {
            if (!data.predicate().test(stack)) continue;
            matchedAny = true;
            if (shouldCareAboutWater && data.waterSensitive()) continue;
            luminance = Math.max(luminance, data.getLuminance(stack));
        }
        if (!matchedAny) {
            luminance = class_2248.method_9503((class_1792)stack.method_7909()).method_9564().method_26213();
        }
        return luminance;
    }
}

