/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.YumiAssertions;
import dev.yumi.commons.event.Event;
import dev.yumi.commons.event.EventCreation;
import dev.yumi.commons.event.FilteredEvent;
import dev.yumi.commons.event.ListenerPhase;
import dev.yumi.commons.event.ListenerPhases;
import dev.yumi.commons.event.invoker.DefaultInvokerFactory;
import dev.yumi.commons.event.invoker.InvokerFactory;
import dev.yumi.commons.event.invoker.SequenceInvokerFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class EventManager<I extends Comparable<? super I>> {
    private final I defaultPhaseId;
    private final Function<String, I> phaseIdParser;
    private final Event<I, EventCreation<I>> creationEvent;

    public EventManager(@NotNull I defaultPhaseId, @NotNull Function<String, I> phaseIdParser) {
        this.defaultPhaseId = defaultPhaseId;
        this.phaseIdParser = phaseIdParser;
        this.creationEvent = new Event<I, EventCreation>(EventCreation.class, defaultPhaseId, new SequenceInvokerFactory<EventCreation>(EventCreation.class));
    }

    @NotNull
    public <T> Event<I, T> create(@NotNull InvokerFactory<T> invokerFactory) {
        return this.create(invokerFactory.type(), invokerFactory);
    }

    @NotNull
    public <T> Event<I, T> create(@NotNull Class<? super T> type) {
        return this.create(type, new DefaultInvokerFactory<T>(type));
    }

    @NotNull
    public <T> Event<I, T> create(@NotNull Class<? super T> type, @NotNull Function<T[], T> implementation) {
        Event<I, ? super T> event = new Event<I, T>(type, this.defaultPhaseId, implementation);
        this.creationEvent.invoker().onEventCreation(this, event);
        return event;
    }

    @NotNull
    public <T> Event<I, T> create(@NotNull Class<? super T> type, @NotNull T emptyImplementation, @NotNull Function<T[], T> implementation) {
        return this.create(type, listeners -> switch (((Object[])listeners).length) {
            case 0 -> emptyImplementation;
            case 1 -> listeners[0];
            default -> implementation.apply((T[])listeners);
        });
    }

    @NotNull
    public <T> Event<I, T> createWithPhases(@NotNull InvokerFactory<T> invokerFactory, I ... defaultPhases) {
        return this.createWithPhases(invokerFactory.type(), invokerFactory, (Comparable[])defaultPhases);
    }

    @NotNull
    public <T> Event<I, T> createWithPhases(@NotNull Class<? super T> type, I ... defaultPhases) {
        return this.createWithPhases(type, new DefaultInvokerFactory<T>(type), (Comparable[])defaultPhases);
    }

    @SafeVarargs
    @NotNull
    public final <T> Event<I, T> createWithPhases(@NotNull Class<? super T> type, @NotNull Function<T[], T> implementation, I ... defaultPhases) {
        return this.createWithPhases(() -> new Event(type, this.defaultPhaseId, implementation), (Comparable[])defaultPhases);
    }

    @NotNull
    public <T, C> FilteredEvent<I, T, C> createFiltered(@NotNull Class<? super C> contextType, @NotNull InvokerFactory<T> invokerFactory) {
        return this.createFiltered(invokerFactory.type(), contextType, invokerFactory);
    }

    @NotNull
    public <T, C> FilteredEvent<I, T, C> createFiltered(@NotNull Class<? super T> type, @NotNull Class<? super C> contextType) {
        return this.createFiltered(type, contextType, new DefaultInvokerFactory<T>(type));
    }

    @NotNull
    public <T, C> FilteredEvent<I, T, C> createFiltered(@NotNull Class<? super T> type, @NotNull Class<? super C> contextType, @NotNull Function<T[], T> implementation) {
        FilteredEvent event = new FilteredEvent(type, this.defaultPhaseId, implementation);
        this.creationEvent.invoker().onEventCreation(this, event);
        return event;
    }

    @NotNull
    public <T, C> FilteredEvent<I, T, C> createFiltered(@NotNull Class<? super T> type, @NotNull Class<? super C> contextType, @NotNull T emptyImplementation, @NotNull Function<T[], T> implementation) {
        return this.createFiltered(type, contextType, listeners -> switch (((Object[])listeners).length) {
            case 0 -> emptyImplementation;
            case 1 -> listeners[0];
            default -> implementation.apply((T[])listeners);
        });
    }

    @NotNull
    public <T, C> FilteredEvent<I, T, C> createFilteredWithPhases(@NotNull Class<C> contextType, @NotNull InvokerFactory<T> invokerFactory, I ... defaultPhases) {
        return this.createFilteredWithPhases(invokerFactory.type(), contextType, invokerFactory, (Comparable[])defaultPhases);
    }

    @NotNull
    public <T, C> FilteredEvent<I, T, C> createFilteredWithPhases(@NotNull Class<? super T> type, @NotNull Class<C> contextType, I ... defaultPhases) {
        return this.createFilteredWithPhases(type, contextType, new DefaultInvokerFactory<T>(type), (Comparable[])defaultPhases);
    }

    @SafeVarargs
    @NotNull
    public final <T, C> FilteredEvent<I, T, C> createFilteredWithPhases(@NotNull Class<? super T> type, @NotNull Class<C> contextType, @NotNull Function<T[], T> implementation, I ... defaultPhases) {
        return (FilteredEvent)this.createWithPhases(() -> new FilteredEvent(type, this.defaultPhaseId, implementation), (Comparable[])defaultPhases);
    }

    @SafeVarargs
    public final void listenAll(Object listener, Event<I, ?> ... events) {
        if (events.length == 0) {
            throw new IllegalArgumentException("Tried to register a listener for an empty event list.");
        }
        Map<Class<?>, I> listenedPhases = this.getListenedPhases(listener.getClass());
        for (Event<I, ?> event : events) {
            if (!event.type().isAssignableFrom(listener.getClass())) {
                throw new IllegalArgumentException("Given object " + String.valueOf(listener) + " is not a listener of event " + String.valueOf(event));
            }
            if (event.type().getTypeParameters().length > 0) {
                throw new IllegalArgumentException("Cannot register a listener for the event " + String.valueOf(event) + " which is using generic parameters with listenAll.");
            }
            listenedPhases.putIfAbsent(event.type(), this.defaultPhaseId);
        }
        for (Event<Comparable, ?> event : events) {
            event.register((Comparable)listenedPhases.get(event.type()), listener);
        }
    }

    @Contract(pure=true)
    @NotNull
    public I defaultPhaseId() {
        return this.defaultPhaseId;
    }

    @Contract(pure=true)
    @NotNull
    public Event<I, EventCreation<I>> getCreationEvent() {
        return this.creationEvent;
    }

    @SafeVarargs
    private <E extends Event<I, ?>> E createWithPhases(Supplier<E> eventSupplier, I ... defaultPhases) {
        this.ensureContainsDefaultPhase((Comparable[])defaultPhases);
        YumiAssertions.ensureNoDuplicates(defaultPhases, id -> new IllegalArgumentException("Duplicate event phase: " + String.valueOf(id)));
        Event event = (Event)eventSupplier.get();
        for (int i = 1; i < defaultPhases.length; ++i) {
            event.addPhaseOrdering(defaultPhases[i - 1], defaultPhases[i]);
        }
        this.creationEvent.invoker().onEventCreation(this, event);
        return (E)event;
    }

    private Map<Class<?>, I> getListenedPhases(Class<?> listenerClass) {
        HashMap map = new HashMap();
        for (Annotation annotation : listenerClass.getAnnotations()) {
            if (annotation instanceof ListenerPhase) {
                ListenerPhase phase = (ListenerPhase)annotation;
                map.put(phase.callbackTarget(), (Comparable)this.phaseIdParser.apply(phase.value()));
                continue;
            }
            if (!(annotation instanceof ListenerPhases)) continue;
            ListenerPhases phases = (ListenerPhases)annotation;
            for (ListenerPhase phase : phases.value()) {
                map.put(phase.callbackTarget(), (Comparable)this.phaseIdParser.apply(phase.value()));
            }
        }
        return map;
    }

    private void ensureContainsDefaultPhase(I[] defaultPhases) {
        for (I id : defaultPhases) {
            if (!id.equals(this.defaultPhaseId)) continue;
            return;
        }
        throw new IllegalArgumentException("The event phases must contain Event.DEFAULT_PHASE.");
    }
}

