/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.event.Event;
import dev.yumi.commons.event.FilteredEvent;
import dev.yumi.commons.event.InvokableEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class SubsetInvoker<I extends Comparable<? super I>, T, C>
implements InvokableEvent<T> {
    private final FilteredEvent<I, T, C> parent;
    private final C context;
    private volatile T invoker;

    public SubsetInvoker(FilteredEvent<I, T, C> parent, C context) {
        this.parent = parent;
        this.context = context;
        this.rebuildInvoker();
    }

    @Override
    @NotNull
    public T invoker() {
        return this.invoker;
    }

    void rebuildInvoker() {
        ArrayList listeners = new ArrayList();
        for (Event.PhaseData entry : this.parent.sortedPhases) {
            FilteredEvent.FilteredPhaseData phase = (FilteredEvent.FilteredPhaseData)entry;
            for (FilteredEvent.Listener listener : phase.listenersData) {
                if (!listener.shouldListen(this.context)) continue;
                listeners.add(listener.listener());
            }
        }
        this.invoker = this.parent.invokerFactory.apply(listeners.toArray(length -> (Object[])Array.newInstance(this.parent.type(), length)));
    }
}

