/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1813;
import net.minecraft.class_1826;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3763;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.BackpackWrapperLookup;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor.RecordItemAccessor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WeightedElement;

public class EntityBackpackAdditionHandler {
    private static final int MAX_DIFFICULTY = 3;
    private static final float MAX_LOCAL_DIFFICULTY = 6.75f;
    private static final String SPAWNED_WITH_BACKPACK = "spawnedWithBackpack";
    private static final String SPAWNED_WITH_JUKEBOX_UPGRADE = "sophisticatedbackpacks:jukebox";
    private static final List<WeightedElement<class_1792>> HELMET_CHANCES = List.of(new WeightedElement(1, (Object)class_1802.field_22027), new WeightedElement(3, (Object)class_1802.field_8805), new WeightedElement(9, (Object)class_1802.field_8862), new WeightedElement(27, (Object)class_1802.field_8743), new WeightedElement(81, (Object)class_1802.field_8267));
    private static final List<WeightedElement<class_1792>> LEGGINGS_CHANCES = List.of(new WeightedElement(1, (Object)class_1802.field_22029), new WeightedElement(3, (Object)class_1802.field_8348), new WeightedElement(9, (Object)class_1802.field_8416), new WeightedElement(27, (Object)class_1802.field_8396), new WeightedElement(81, (Object)class_1802.field_8570));
    private static final List<WeightedElement<class_1792>> BOOTS_CHANCES = List.of(new WeightedElement(1, (Object)class_1802.field_22030), new WeightedElement(3, (Object)class_1802.field_8285), new WeightedElement(9, (Object)class_1802.field_8753), new WeightedElement(27, (Object)class_1802.field_8660), new WeightedElement(81, (Object)class_1802.field_8370));
    private static final Map<class_1792, Float> dropChanceMultiplier = Map.of(ModItems.BACKPACK, Float.valueOf(1.0f), ModItems.COPPER_BACKPACK, Float.valueOf(1.25f), ModItems.IRON_BACKPACK, Float.valueOf(1.5f), ModItems.GOLD_BACKPACK, Float.valueOf(3.0f), ModItems.DIAMOND_BACKPACK, Float.valueOf(4.5f), ModItems.NETHERITE_BACKPACK, Float.valueOf(6.0f));
    private static final List<WeightedElement<BackpackAddition>> BACKPACK_CHANCES = List.of(new WeightedElement(1, (Object)new BackpackAddition((class_1792)ModItems.NETHERITE_BACKPACK, 4, HELMET_CHANCES.subList(0, 1), LEGGINGS_CHANCES.subList(0, 1), BOOTS_CHANCES.subList(0, 1))), new WeightedElement(5, (Object)new BackpackAddition((class_1792)ModItems.DIAMOND_BACKPACK, 3, HELMET_CHANCES.subList(0, 2), LEGGINGS_CHANCES.subList(0, 2), BOOTS_CHANCES.subList(0, 2))), new WeightedElement(25, (Object)new BackpackAddition((class_1792)ModItems.GOLD_BACKPACK, 2, HELMET_CHANCES.subList(1, 3), LEGGINGS_CHANCES.subList(1, 3), BOOTS_CHANCES.subList(1, 3))), new WeightedElement(125, (Object)new BackpackAddition((class_1792)ModItems.IRON_BACKPACK, 1, HELMET_CHANCES.subList(2, 4), LEGGINGS_CHANCES.subList(2, 4), BOOTS_CHANCES.subList(2, 4))), new WeightedElement(250, (Object)new BackpackAddition((class_1792)ModItems.COPPER_BACKPACK, 1, HELMET_CHANCES.subList(2, 4), LEGGINGS_CHANCES.subList(3, 5), BOOTS_CHANCES.subList(3, 5))), new WeightedElement(625, (Object)new BackpackAddition((class_1792)ModItems.BACKPACK, 0, HELMET_CHANCES.subList(3, 5), LEGGINGS_CHANCES.subList(3, 5), BOOTS_CHANCES.subList(3, 5))));
    private static final Map<Integer, List<WeightedElement<BackpackAddition>>> DIFFICULTY_BACKPACK_CHANCES = Map.of(0, BACKPACK_CHANCES, 1, BACKPACK_CHANCES.subList(1, 5), 2, BACKPACK_CHANCES.subList(2, 5));
    private static List<class_1813> musicDiscs = null;
    private static final List<ApplicableEffect> APPLICABLE_EFFECTS = List.of(new ApplicableEffect(List.of(class_1294.field_5907, class_1294.field_5924), 1), new ApplicableEffect(class_1294.field_5918), new ApplicableEffect(class_1294.field_5898), new ApplicableEffect(class_1294.field_5914), new ApplicableEffect(class_1294.field_5904), new ApplicableEffect(class_1294.field_5910));

    private EntityBackpackAdditionHandler() {
    }

    static void addBackpack(class_1588 monster, class_1936 level, class_1266 difficultyInstance) {
        class_3763 raider;
        class_5819 rnd = level.method_8409();
        if (!Config.SERVER.entityBackpackAdditions.canWearBackpack(monster.method_5864()) || rnd.method_43048((int)(1.0 / (Double)Config.SERVER.entityBackpackAdditions.chance.get())) != 0 || monster instanceof class_3763 && (raider = (class_3763)monster).method_16478() != null) {
            return;
        }
        int index = Ints.constrainToRange((int)((int)Math.floor((float)DIFFICULTY_BACKPACK_CHANCES.size() / 6.75f * difficultyInstance.method_5457() - 0.1f)), (int)0, (int)DIFFICULTY_BACKPACK_CHANCES.size());
        RandHelper.getRandomWeightedElement((class_5819)rnd, DIFFICULTY_BACKPACK_CHANCES.get(index)).ifPresent(backpackAddition -> {
            class_1799 backpack = new class_1799((class_1935)backpackAddition.getBackpackItem());
            int minDifficulty = backpackAddition.getMinDifficulty();
            int difficulty = Math.max(minDifficulty, rnd.method_43048(4));
            EntityBackpackAdditionHandler.equipBackpack(monster, backpack, difficulty, Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.playJukebox.get()) && rnd.method_43048(4) == 0, level, rnd);
            EntityBackpackAdditionHandler.applyPotions(monster, difficulty, minDifficulty, rnd);
            EntityBackpackAdditionHandler.raiseHealth(monster, minDifficulty);
            if (Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.equipWithArmor.get())) {
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getHelmetChances(), class_1304.field_6169, level, difficultyInstance);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getLeggingsChances(), class_1304.field_6172, level, difficultyInstance);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getBootsChances(), class_1304.field_6166, level, difficultyInstance);
            }
            monster.method_5780(SPAWNED_WITH_BACKPACK);
        });
    }

    private static void equipArmorPiece(class_1588 monster, class_5819 rnd, int minDifficulty, List<WeightedElement<class_1792>> armorChances, class_1304 slot, class_1936 level, class_1266 difficultyInstance) {
        RandHelper.getRandomWeightedElement((class_5819)rnd, armorChances).ifPresent(armorPiece -> {
            if (armorPiece != class_1802.field_8162) {
                class_1799 armorStack = new class_1799((class_1935)armorPiece);
                if (rnd.method_43048(6 - minDifficulty) == 0) {
                    float additionalDifficulty = difficultyInstance.method_5458();
                    int enchantmentLevel = (int)(5.0f + additionalDifficulty * 18.0f + (float)(minDifficulty * 6));
                    class_1890.method_8233((class_5819)rnd, (class_1799)armorStack, (int)enchantmentLevel, (boolean)true);
                }
                monster.method_5673(slot, armorStack);
            }
        });
    }

    private static void equipBackpack(class_1588 monster, class_1799 backpack, int difficulty, boolean playMusicDisc, class_1936 level, class_5819 rnd) {
        EntityBackpackAdditionHandler.getSpawnEgg(monster.method_5864()).ifPresent(egg -> BackpackWrapperLookup.get(backpack).ifPresent(w -> {
            w.setColors(EntityBackpackAdditionHandler.getPrimaryColor(egg), EntityBackpackAdditionHandler.getSecondaryColor(egg));
            EntityBackpackAdditionHandler.setLoot(monster, w, difficulty, level);
            if (playMusicDisc) {
                w.getInventoryHandler();
                if (w.getUpgradeHandler().getSlotCount() > 0) {
                    monster.method_5780(SPAWNED_WITH_JUKEBOX_UPGRADE);
                    EntityBackpackAdditionHandler.addJukeboxUpgradeAndRandomDisc(w, rnd);
                }
            }
        }));
        monster.method_5673(class_1304.field_6174, backpack);
        monster.method_5946(class_1304.field_6174, 0.0f);
    }

    private static void addJukeboxUpgradeAndRandomDisc(IStorageWrapper w, class_5819 rnd) {
        w.getUpgradeHandler().setStackInSlot(0, new class_1799((class_1935)ModItems.JUKEBOX_UPGRADE));
        Iterator it = w.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).iterator();
        if (it.hasNext()) {
            JukeboxUpgradeItem.Wrapper wrapper = (JukeboxUpgradeItem.Wrapper)it.next();
            List<class_1813> musicDiscs = EntityBackpackAdditionHandler.getMusicDiscs();
            wrapper.setDisc(new class_1799((class_1935)musicDiscs.get(rnd.method_43048(musicDiscs.size()))));
        }
    }

    private static List<class_1813> getMusicDiscs() {
        if (musicDiscs == null) {
            Map<class_3414, class_1813> records = RecordItemAccessor.getByName();
            if (records == null) {
                musicDiscs = new ArrayList<class_1813>();
            } else {
                HashSet blockedDiscs = new HashSet((Collection)Config.SERVER.entityBackpackAdditions.discBlockList.get());
                musicDiscs = new ArrayList<class_1813>();
                records.forEach((sound, musicDisc) -> {
                    if (!blockedDiscs.contains(class_7923.field_41178.method_10221(musicDisc).toString())) {
                        musicDiscs.add((class_1813)musicDisc);
                    }
                });
            }
        }
        return musicDiscs;
    }

    private static void raiseHealth(class_1588 monster, int minDifficulty) {
        if (Boolean.FALSE.equals(Config.SERVER.entityBackpackAdditions.buffHealth.get())) {
            return;
        }
        class_1324 maxHealth = monster.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            double healthAddition = maxHealth.method_6201() * (double)minDifficulty;
            if (healthAddition > 0.1) {
                maxHealth.method_26837(new class_1322("Backpack bearer health bonus", healthAddition, class_1322.class_1323.field_6328));
            }
            monster.method_6033(monster.method_6063());
        }
    }

    private static Optional<class_1826> getSpawnEgg(class_1299<?> entityType) {
        return Optional.ofNullable(class_1826.method_8019(entityType));
    }

    private static int getPrimaryColor(class_1826 egg) {
        Integer primaryColor = egg.method_8016(0);
        return primaryColor == null ? -1 : primaryColor;
    }

    private static int getSecondaryColor(class_1826 egg) {
        Integer secondaryColor = egg.method_8016(1);
        return secondaryColor == null ? -1 : secondaryColor;
    }

    private static void setLoot(class_1588 monster, IBackpackWrapper backpackWrapper, int difficulty, class_1936 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return;
        }
        if (Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.addLoot.get())) {
            EntityBackpackAdditionHandler.addLoot(monster, backpackWrapper, difficulty);
        }
    }

    private static void applyPotions(class_1588 monster, int difficulty, int minDifficulty, class_5819 rnd) {
        if (Boolean.TRUE.equals(Config.SERVER.entityBackpackAdditions.buffWithPotionEffects.get())) {
            RandHelper.getNRandomElements(APPLICABLE_EFFECTS, (int)(difficulty + 2)).forEach(applicableEffect -> {
                int amplifier = Math.min(Math.max(minDifficulty, rnd.method_43048(difficulty + 1)), applicableEffect.getMaxAmplifier());
                monster.method_6092(new class_1293(applicableEffect.getRandomEffect(rnd), 36000, amplifier));
            });
        }
    }

    private static void addLoot(class_1588 monster, IBackpackWrapper backpackWrapper, int difficulty) {
        if (difficulty != 0) {
            Config.SERVER.entityBackpackAdditions.getLootTableName(monster.method_5864()).ifPresent(lootTableName -> {
                float lootPercentage = (float)difficulty / 3.0f;
                backpackWrapper.setLoot((class_2960)lootTableName, lootPercentage);
            });
        }
    }

    static boolean handleBackpackDrop(class_1309 target, class_1282 source, Collection<class_1542> drops, int lootingLevel, boolean recentlyHit) {
        if (target.method_5752().contains(SPAWNED_WITH_BACKPACK)) {
            Config.Server.EntityBackpackAdditionsConfig additionsConfig = Config.SERVER.entityBackpackAdditions;
            class_1799 backpack = target.method_6118(class_1304.field_6174);
            if (EntityBackpackAdditionHandler.shouldDropBackpack(source, additionsConfig, target, backpack, lootingLevel)) {
                class_1542 backpackEntity = new class_1542(target.method_37908(), target.method_23317(), target.method_23318(), target.method_23321(), backpack);
                drops.add(backpackEntity);
                target.method_5673(class_1304.field_6174, class_1799.field_8037);
                target.method_5752().remove(SPAWNED_WITH_BACKPACK);
            } else {
                EntityBackpackAdditionHandler.removeContentsUuid(backpack);
            }
        }
        return false;
    }

    private static boolean shouldDropBackpack(class_1282 source, Config.Server.EntityBackpackAdditionsConfig additionsConfig, class_1309 mob, class_1799 backpack, int lootingLevel) {
        if (!(source.method_5529() instanceof class_1657)) {
            return false;
        }
        if (!Boolean.TRUE.equals(additionsConfig.dropToFakePlayers.get()) && source.method_5529() instanceof FakePlayer) {
            return false;
        }
        float lootingChanceMultiplier = dropChanceMultiplier.getOrDefault(backpack.method_7909(), Float.valueOf(1.0f)).floatValue();
        return (double)mob.method_37908().field_9229.method_43057() < ((Double)additionsConfig.backpackDropChance.get() + (double)lootingLevel * (Double)additionsConfig.lootingChanceIncreasePerLevel.get()) * (double)lootingChanceMultiplier;
    }

    public static void removeBeneficialEffects(class_1548 creeper) {
        if (creeper.method_5752().contains(SPAWNED_WITH_BACKPACK)) {
            creeper.method_6026().removeIf(e -> e.method_5579().method_5573());
        }
    }

    public static void removeBackpackUuid(class_1588 entity, class_1937 level) {
        if (level.method_8608() || entity.method_35049() != class_1297.class_5529.field_26998 && entity.method_35049() != class_1297.class_5529.field_26999 || !entity.method_5752().contains(SPAWNED_WITH_BACKPACK)) {
            return;
        }
        class_1799 stack = entity.method_6118(class_1304.field_6174);
        EntityBackpackAdditionHandler.removeContentsUuid(stack);
    }

    private static void removeContentsUuid(class_1799 stack) {
        BackpackWrapperLookup.get(stack).flatMap(IStorageWrapper::getContentsUuid).ifPresent(uuid -> BackpackStorage.get().removeBackpackContents((UUID)uuid));
    }

    public static void onLivingUpdate(class_1309 entity) {
        if (!entity.method_5752().contains(SPAWNED_WITH_JUKEBOX_UPGRADE)) {
            return;
        }
        BackpackWrapperLookup.get(entity.method_6118(class_1304.field_6174)).ifPresent(backpackWrapper -> backpackWrapper.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).forEach(wrapper -> {
            if (wrapper.isPlaying()) {
                wrapper.tick((class_1297)entity, entity.method_37908(), entity.method_24515());
            } else {
                wrapper.play(entity);
            }
        }));
    }

    private static class ApplicableEffect {
        private final List<class_1291> effects;
        private final int maxAmplifier;

        private ApplicableEffect(class_1291 effect) {
            this(List.of(effect), Integer.MAX_VALUE);
        }

        private ApplicableEffect(List<class_1291> effects, int maxAmplifier) {
            this.effects = effects;
            this.maxAmplifier = maxAmplifier;
        }

        public class_1291 getRandomEffect(class_5819 random) {
            return this.effects.get(random.method_43048(this.effects.size()));
        }

        public int getMaxAmplifier() {
            return this.maxAmplifier;
        }
    }

    private record BackpackAddition(class_1792 backpackItem, int minDifficulty, List<WeightedElement<class_1792>> helmetChances, List<WeightedElement<class_1792>> leggingsChances, List<WeightedElement<class_1792>> bootsChances) {
        public List<WeightedElement<class_1792>> getHelmetChances() {
            return this.helmetChances;
        }

        public List<WeightedElement<class_1792>> getLeggingsChances() {
            return this.leggingsChances;
        }

        public List<WeightedElement<class_1792>> getBootsChances() {
            return this.bootsChances;
        }

        public class_1792 getBackpackItem() {
            return this.backpackItem;
        }

        public int getMinDifficulty() {
            return this.minDifficulty;
        }
    }
}

