/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.plugins.impl.opus.OpusManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.Denoiser;
import de.maxhenkel.voicechat.voice.client.MicActivator;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import de.maxhenkel.voicechat.voice.client.VolumeManager;
import de.maxhenkel.voicechat.voice.client.microphone.Microphone;
import de.maxhenkel.voicechat.voice.client.microphone.MicrophoneManager;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_310;

public class MicThread
extends Thread {
    @Nullable
    private final ClientVoicechat client;
    @Nullable
    private final ClientVoicechatConnection connection;
    @Nullable
    private Microphone mic;
    @Nullable
    private MicrophoneException microphoneError;
    private final VolumeManager volumeManager;
    private boolean running;
    private boolean microphoneLocked;
    private boolean wasWhispering;
    private final OpusEncoder encoder;
    @Nullable
    private Denoiser denoiser;
    private final Consumer<MicrophoneException> onError;
    private final MicActivator micActivator = new MicActivator();
    private volatile boolean wasPTT;
    private boolean hasSentAudio;
    private final AtomicLong sequenceNumber = new AtomicLong();
    private volatile boolean stopPacketSent = true;

    public MicThread(@Nullable ClientVoicechat client, @Nullable ClientVoicechatConnection connection, Consumer<MicrophoneException> onError) {
        this.client = client;
        this.connection = connection;
        this.onError = onError;
        this.running = true;
        this.encoder = OpusManager.createEncoder(connection == null ? ServerConfig.Codec.VOIP.getMode() : connection.getData().getCodec().getMode());
        this.denoiser = Denoiser.createDenoiser();
        if (this.denoiser == null) {
            Voicechat.LOGGER.warn("Denoiser not available", new Object[0]);
        }
        this.volumeManager = new VolumeManager();
        this.setDaemon(true);
        this.setName("MicrophoneThread");
        this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
    }

    public void getError(Consumer<MicrophoneException> onError) {
        if (this.microphoneError != null) {
            onError.accept(this.microphoneError);
        }
    }

    @Override
    public void run() {
        Microphone mic = this.getMic();
        if (mic == null) {
            return;
        }
        while (this.running) {
            if (this.connection != null) {
                this.connection.checkTimeout();
                if (!this.running) break;
            }
            if (this.microphoneLocked || ClientManager.getPlayerStateManager().isDisabled()) {
                this.micActivator.stopActivating();
                this.wasPTT = false;
                this.wasWhispering = false;
                this.flushIfNeeded();
                if (!this.microphoneLocked && ClientManager.getPlayerStateManager().isDisabled()) {
                    if (mic.isStarted()) {
                        mic.stop();
                    }
                    if (this.denoiser != null) {
                        this.denoiser.close();
                    }
                }
                Utils.sleep(10);
                continue;
            }
            short[] audio = this.pollMic();
            if (audio == null) continue;
            boolean sentAudio = false;
            MicrophoneActivationType type = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get();
            if (type.equals((Object)MicrophoneActivationType.PTT)) {
                sentAudio = this.ptt(audio);
            } else if (type.equals((Object)MicrophoneActivationType.VOICE)) {
                sentAudio = this.voice(audio);
            }
            if (sentAudio) continue;
            this.sendAudio(null, ClientManager.getPttKeyHandler().isWhisperDown());
        }
    }

    @Nullable
    public short[] pollMic() {
        Microphone mic = this.getMic();
        if (mic == null) {
            throw new IllegalStateException("No microphone available");
        }
        if (!mic.isStarted()) {
            mic.start();
        }
        if (this.denoiser != null && this.denoiser.isClosed()) {
            this.denoiser = Denoiser.createDenoiser();
        }
        if (mic.available() < 960) {
            Utils.sleep(5);
            return null;
        }
        short[] buff = mic.read();
        this.volumeManager.adjustVolumeMono(buff, VoicechatClient.CLIENT_CONFIG.microphoneAmplification.get().floatValue());
        return this.denoiseIfEnabled(buff);
    }

    @Nullable
    private Microphone getMic() {
        if (!this.running) {
            return null;
        }
        if (this.mic == null) {
            try {
                this.mic = MicrophoneManager.createMicrophone();
                class_310.method_1551().execute(ClientManager.instance()::checkMicrophonePermissions);
            }
            catch (MicrophoneException e) {
                this.onError.accept(e);
                this.microphoneError = e;
                this.running = false;
                return null;
            }
        }
        return this.mic;
    }

    private boolean voice(short[] audio) {
        this.wasPTT = false;
        if (ClientManager.getPlayerStateManager().isMuted()) {
            this.micActivator.stopActivating();
            this.wasWhispering = false;
            return false;
        }
        this.wasWhispering = ClientManager.getPttKeyHandler().isWhisperDown();
        return this.micActivator.push(audio, a -> this.sendAudio((short[])a, this.wasWhispering));
    }

    private boolean ptt(short[] audio) {
        this.micActivator.stopActivating();
        if (!ClientManager.getPttKeyHandler().isAnyDown()) {
            if (this.wasPTT) {
                this.wasPTT = false;
                this.wasWhispering = false;
            }
            return false;
        }
        this.wasPTT = true;
        this.wasWhispering = ClientManager.getPttKeyHandler().isWhisperDown();
        this.sendAudio(audio, this.wasWhispering);
        return true;
    }

    public short[] denoiseIfEnabled(short[] audio) {
        if (this.denoiser != null && VoicechatClient.CLIENT_CONFIG.denoiser.get().booleanValue()) {
            return this.denoiser.denoise(audio);
        }
        return audio;
    }

    private void flush() {
        this.sendStopPacket();
        if (!this.encoder.isClosed()) {
            this.encoder.resetState();
        }
        if (this.client == null) {
            return;
        }
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.flushChunkThreaded(class_310.method_1551().method_1548().method_1677().getId());
    }

    private void sendAudio(@Nullable short[] rawAudio, boolean whispering) {
        short[] mergedAudio = ClientPluginManager.instance().onMergeClientSound(rawAudio);
        if (mergedAudio == null) {
            this.flushIfNeeded();
            return;
        }
        short[] finalAudio = ClientPluginManager.instance().onClientSound(mergedAudio, whispering);
        if (finalAudio == null) {
            this.flushIfNeeded();
            return;
        }
        this.sendAudioPacket(finalAudio, whispering);
        this.hasSentAudio = true;
    }

    private void flushIfNeeded() {
        if (!this.hasSentAudio) {
            return;
        }
        this.flush();
        this.hasSentAudio = false;
    }

    public boolean isTalking() {
        return !this.microphoneLocked && (this.micActivator.isActivating() || this.wasPTT);
    }

    public boolean isWhispering() {
        return this.isTalking() && this.wasWhispering;
    }

    public void setMicrophoneLocked(boolean microphoneLocked) {
        this.microphoneLocked = microphoneLocked;
        this.micActivator.stopActivating();
        this.wasPTT = false;
    }

    public void close() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (Thread.currentThread() != this) {
            try {
                this.join(100L);
            }
            catch (InterruptedException e) {
                Voicechat.LOGGER.error("Interrupted while waiting for mic thread to close", e);
            }
        }
        if (this.mic != null) {
            this.mic.close();
        }
        this.encoder.close();
        if (this.denoiser != null) {
            this.denoiser.close();
        }
        this.flush();
    }

    private void sendAudioPacket(short[] audio, boolean whispering) {
        if (this.connection != null && this.connection.isInitialized()) {
            byte[] encoded = this.encoder.encode(audio);
            this.connection.sendToServer(new NetworkMessage(new MicPacket(encoded, whispering, this.sequenceNumber.getAndIncrement())));
            this.stopPacketSent = false;
        }
        try {
            if (this.client != null && this.client.getRecorder() != null) {
                this.client.getRecorder().appendChunk(class_310.method_1551().method_1548().method_1677().getId(), System.currentTimeMillis(), PositionalAudioUtils.convertToStereo(audio));
            }
        }
        catch (IOException e) {
            Voicechat.LOGGER.error("Failed to record audio", e);
            this.client.setRecording(false);
        }
    }

    private void sendStopPacket() {
        if (this.stopPacketSent) {
            return;
        }
        if (this.connection == null || !this.connection.isInitialized()) {
            return;
        }
        this.connection.sendToServer(new NetworkMessage(new MicPacket(new byte[0], false, this.sequenceNumber.getAndIncrement())));
        this.stopPacketSent = true;
    }
}

