/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlock;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.hlysine.create_power_loader.content.trains.CPLGlobalStation;
import com.hlysine.create_power_loader.content.trains.StationChunkLoader;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChunkLoaderBlockEntity
extends KineticBlockEntity
implements ChunkLoader {
    public final LoaderType type;
    protected class_2338 lastBlockPos;
    protected boolean lastEnabled;
    protected int lastRange;
    protected int chunkUpdateCooldown;
    protected int chunkUnloadCooldown;
    protected Set<ChunkLoadManager.LoadedChunkPos> forcedChunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
    @Nullable
    private StationBlockEntity attachedStation = null;
    public boolean isLoaderActive = false;
    private boolean deferredEdgePoint = false;

    public AbstractChunkLoaderBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state, LoaderType type) {
        super(typeIn, pos, state);
        this.type = type;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        return this.forcedChunks;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.STATIC;
    }

    @Override
    public LoaderType getLoaderType() {
        return this.type;
    }

    @Override
    @Nullable
    public Pair<class_2960, class_2338> getLocation() {
        return Pair.of((Object)this.method_10997().method_27983().method_29177(), (Object)this.method_11016());
    }

    public void updateAttachedStation(StationBlockEntity be) {
        CPLGlobalStation station;
        GlobalStation globalStation;
        if (this.attachedStation != null) {
            globalStation = this.attachedStation.getStation();
            if (globalStation instanceof CPLGlobalStation) {
                station = (CPLGlobalStation)globalStation;
                station.getLoader().removeAttachment(this.method_11016());
            }
        } else {
            this.removeFromManager();
        }
        this.attachedStation = be;
        if (this.attachedStation != null) {
            globalStation = this.attachedStation.getStation();
            if (globalStation instanceof CPLGlobalStation) {
                station = (CPLGlobalStation)globalStation;
                station.getLoader().addAttachment(this.type, this.method_11016());
            } else {
                this.deferredEdgePoint = true;
            }
        } else if (!this.field_11863.method_8608()) {
            this.addToManager();
        }
    }

    public StationBlockEntity getAttachedStation() {
        return this.attachedStation;
    }

    public void initialize() {
        super.initialize();
        if (this.method_10997() != null && ((Boolean)this.method_11010().method_11654((class_2769)AbstractChunkLoaderBlock.ATTACHED)).booleanValue()) {
            class_2586 be = this.method_10997().method_8321(this.method_11016().method_10093(((class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10153()));
            if (!(be instanceof StationBlockEntity)) {
                return;
            }
            StationBlockEntity sbe = (StationBlockEntity)be;
            this.updateAttachedStation(sbe);
        } else if (!this.field_11863.method_8608()) {
            this.addToManager();
        }
    }

    public void reclaimChunks(Set<ChunkLoadManager.LoadedChunkPos> forcedChunks) {
        this.forcedChunks.addAll(forcedChunks);
    }

    public void tick() {
        boolean server;
        super.tick();
        boolean bl = server = (!this.field_11863.field_9236 || this.isVirtual()) && this.field_11863 instanceof class_3218;
        if (!server) {
            this.spawnParticles();
        }
        if (server && this.chunkUpdateCooldown-- <= 0) {
            this.chunkUpdateCooldown = (Integer)CPLConfigs.server().getFor((LoaderType)this.type).chunkUpdateInterval.get();
            if (this.needsUpdate()) {
                this.method_5431();
                this.updateForcedChunks();
            }
        }
        if (server) {
            GlobalStation globalStation;
            if (this.deferredEdgePoint && (globalStation = this.attachedStation.getStation()) instanceof CPLGlobalStation) {
                CPLGlobalStation station = (CPLGlobalStation)globalStation;
                station.getLoader().addAttachment(this.type, this.method_11016());
                this.deferredEdgePoint = false;
            }
            boolean wasLoaderActive = this.isLoaderActive;
            boolean bl2 = this.isLoaderActive = StationChunkLoader.isEnabledForStation(this.type) && this.attachedStation != null && this.attachedStation.getStation() != null && this.attachedStation.getStation().getPresentTrain() != null;
            if (wasLoaderActive != this.isLoaderActive) {
                this.notifyUpdate();
            }
        }
    }

    private boolean needsUpdate() {
        if (this.lastBlockPos == null) {
            return true;
        }
        return !this.lastBlockPos.equals((Object)this.method_11016()) || this.lastEnabled != this.canLoadChunks() || this.lastRange != this.getLoadingRange() || this.chunkUnloadCooldown > 0;
    }

    protected void updateForcedChunks() {
        boolean resetStates = true;
        if (this.canLoadChunks()) {
            ChunkLoadManager.updateForcedChunks(this.field_11863.method_8503(), new ChunkLoadManager.LoadedChunkPos(this.method_10997(), this.method_11016()), this.method_11016(), this.getLoadingRange(), this.forcedChunks);
        } else if (this.chunkUnloadCooldown >= (Integer)CPLConfigs.server().getFor((LoaderType)this.type).unloadGracePeriod.get()) {
            ChunkLoadManager.unforceAllChunks(this.field_11863.method_8503(), this.method_11016(), this.forcedChunks);
        } else {
            this.chunkUnloadCooldown += ((Integer)CPLConfigs.server().getFor((LoaderType)this.type).chunkUpdateInterval.get()).intValue();
            resetStates = false;
        }
        if (resetStates) {
            this.chunkUnloadCooldown = 0;
            this.lastBlockPos = this.method_11016().method_10062();
            this.lastEnabled = this.canLoadChunks();
            this.lastRange = this.getLoadingRange();
        }
    }

    public boolean canLoadChunks() {
        return this.isSpeedRequirementFulfilled() && (Boolean)CPLConfigs.server().getFor((LoaderType)this.type).enableStatic.get() != false;
    }

    public boolean isSpeedRequirementFulfilled() {
        if (!super.isSpeedRequirementFulfilled()) {
            return false;
        }
        class_2680 state = this.method_11010();
        if (!(this.method_11010().method_26204() instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)state.method_26204();
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        float minSpeed = minimumRequiredSpeedLevel.getSpeedValue();
        double requirement = (double)(minSpeed * (float)Math.pow(2.0, this.getLoadingRange())) * (Double)CPLConfigs.server().getFor((LoaderType)this.type).speedMultiplier.get();
        return (double)Math.abs(this.getSpeed()) >= requirement;
    }

    public void destroy() {
        boolean server;
        super.destroy();
        boolean bl = server = (!this.field_11863.field_9236 || this.isVirtual()) && this.field_11863 instanceof class_3218;
        if (server) {
            ChunkLoadManager.unforceAllChunks(this.field_11863.method_8503(), this.method_11016(), this.forcedChunks);
        }
        this.updateAttachedStation(null);
        this.removeFromManager();
    }

    public void remove() {
        boolean server;
        super.remove();
        boolean bl = server = (!this.field_11863.field_9236 || this.isVirtual()) && this.field_11863 instanceof class_3218;
        if (server) {
            ChunkLoadManager.unforceAllChunks(this.field_11863.method_8503(), this.method_11016(), this.forcedChunks);
        }
        this.updateAttachedStation(null);
        this.removeFromManager();
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.isLoaderActive = compound.method_10577("CoreActive");
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("CoreActive", this.isLoaderActive);
        super.write(compound, clientPacket);
    }

    public abstract int getLoadingRange();

    protected void spawnParticles() {
        if (this.field_11863 == null) {
            return;
        }
        if (!this.canLoadChunks()) {
            return;
        }
        class_5819 r = this.field_11863.method_8409();
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        if (r.method_43048(4) != 0) {
            return;
        }
        double speed = 0.0625;
        class_243 normal = class_243.method_24954((class_2382)((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525)).method_10163());
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)r, (float)0.5f).method_18805(1.0, 1.0, 1.0).method_1029().method_1021(0.25 + r.method_43058() * 0.125)).method_1019(normal.method_1021(0.5));
        class_243 motion = normal.method_1021(speed);
        this.field_11863.method_8406((class_2394)class_2398.field_11214, v2.field_1352, v2.field_1351, v2.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
    }
}

