/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.network.ClientBoundPlaySplashParticlesMessage;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends class_2275
implements class_2343 {
    public ModCauldronBlock(class_4970.class_2251 properties) {
        super(properties, Map.of());
    }

    public class_1792 method_8389() {
        return class_1802.field_8638;
    }

    public abstract class_2758 getLevelProperty();

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)this.getLevelProperty());
    }

    public void method_9504(class_2680 state, class_1937 level, class_2338 pos, class_1959.class_1963 precipitation) {
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (this.method_31616(state, pos, entity)) {
            if (!level.field_9236) {
                ModCauldronBlock.playSplashEffects(entity, this.method_31615(state));
            }
            super.method_9554(level, state, pos, entity, 0.0f);
        } else {
            super.method_9554(level, state, pos, entity, fallDistance);
        }
    }

    public static void playExtinguishSound(class_1937 level, class_2338 pos, class_1297 entity) {
        level.method_8396(null, pos, class_3417.field_15222, entity.method_5634(), 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (this.method_31616(state, pos, entity)) {
            entity.field_5957 = true;
            if (level.field_9236) {
                return;
            }
            if (entity.method_5809()) {
                class_2586 class_25862;
                entity.method_5646();
                ModCauldronBlock.playExtinguishSound(level, pos, entity);
                if (entity.method_36971(level, pos) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
                    te.consumeOneLayer();
                    level.method_33596(entity, class_5712.field_28733, pos);
                }
            }
            this.handleEntityInside(state, level, pos, entity);
        }
    }

    protected abstract void handleEntityInside(class_2680 var1, class_1937 var2, class_2338 var3, class_1297 var4);

    public boolean doCraftItem(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, SoftFluidStack fluid, class_1799 itemStack, class_1799 crafted, float layerPerItem, int itemCountMultiplier) {
        int maxRecolorable = (int)((float)(crafted.method_7947() * itemCountMultiplier * fluid.getCount()) / layerPerItem);
        int amountToRecolor = Math.min(maxRecolorable, itemStack.method_7947());
        if (amountToRecolor <= 0) {
            return false;
        }
        crafted.method_7939(amountToRecolor);
        level.method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.3f);
        if (!(player instanceof class_3222)) {
            return true;
        }
        class_3222 serverPlayer = (class_3222)player;
        player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
        class_174.field_24478.method_23889(serverPlayer, pos, itemStack);
        if (!player.method_7337()) {
            itemStack.method_7934(amountToRecolor);
            fluid.shrink(class_3532.method_15386((float)(layerPerItem * (float)amountToRecolor / (float)itemCountMultiplier)));
        }
        if (itemStack.method_7960()) {
            player.method_6122(hand, crafted);
        } else if (!player.method_31548().method_7394(crafted)) {
            player.method_7328(crafted, false);
        }
        return true;
    }

    public abstract class_2680 updateStateOnFluidChange(class_2680 var1, class_1937 var2, class_2338 var3, SoftFluidStack var4);

    public static void addSurfaceParticles(class_2394 type, class_1937 level, class_2338 pos, int count, double surface, class_5819 rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.method_10263() + 0.1875 + (double)rand.method_43057() * 0.625;
            double y = (double)pos.method_10264() + surface;
            double z = (double)pos.method_10260() + 0.1875 + (double)rand.method_43057() * 0.625;
            level.method_8406(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public static void playSplashEffects(class_1297 entity, double waterHeight) {
        entity.method_32876(class_5712.field_28160);
        class_1937 level = entity.method_37908();
        class_1297 feetEntity = entity.method_5782() && entity.method_5642() != null ? entity.method_5642() : entity;
        float offset = feetEntity == entity ? 0.2f : 0.9f;
        class_243 movement = feetEntity.method_18798();
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.field_1352 * movement.field_1352 * 0.2 + movement.field_1351 * movement.field_1351 + movement.field_1350 * movement.field_1350 * 0.2) * offset);
        class_2338 pos = class_2338.method_49638((class_2374)entity.method_19538());
        class_243 hitPos = new class_243(entity.method_23317(), (double)pos.method_10264() + waterHeight, entity.method_23321());
        class_5819 rand = level.field_9229;
        if (speed < 0.25f) {
            level.method_43128(null, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), entity.method_5625(), entity.method_5634(), speed, 1.0f + (rand.method_43057() - rand.method_43057()) * 0.4f);
        } else {
            level.method_43128(null, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), entity.method_5672(), entity.method_5634(), speed, 1.0f + (rand.method_43057() - rand.method_43057()) * 0.4f);
        }
        ClientBoundPlaySplashParticlesMessage particlePacket = new ClientBoundPlaySplashParticlesMessage(hitPos, speed, feetEntity.method_17681());
        ModNetwork.CHANNEL.sentToAllClientPlayersTrackingEntityAndSelf(entity, (Message)particlePacket);
    }
}

