/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.hat;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfo;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class TrainHatInfoReloadListener {
    private static final Map<class_1299<?>, TrainHatInfo> ENTITY_INFO_MAP = new HashMap();
    public static final String HAT_INFO_DIRECTORY = "train_hat_info";
    public static final IdentifiableResourceReloadListener LISTENER = new SimpleSynchronousResourceReloadListener(){
        private static final class_2960 ID = Create.asResource("train_hat_info_reload_listener");

        public void method_14491(class_3300 resourceManager) {
            TrainHatInfoReloadListener.registerOffsetOverrides(resourceManager);
        }

        public class_2960 getFabricId() {
            return ID;
        }
    };
    private static final TrainHatInfo DEFAULT = new TrainHatInfo("", 0, class_243.field_1353, 1.0f);

    private static void registerOffsetOverrides(class_3300 manager) {
        ENTITY_INFO_MAP.clear();
        class_7654 converter = class_7654.method_45114((String)HAT_INFO_DIRECTORY);
        converter.method_45113(manager).forEach((location, resource) -> {
            String[] splitPath = location.method_12832().split("/");
            class_2960 entityName = new class_2960(location.method_12836(), splitPath[splitPath.length - 1].replace(".json", ""));
            if (!class_7923.field_41177.method_10250(entityName)) {
                Create.LOGGER.error("Failed to load train hat info for entity {} as it does not exist.", (Object)entityName);
                return;
            }
            try (BufferedReader reader = resource.method_43039();){
                JsonObject json = class_3518.method_15255((Reader)reader);
                ENTITY_INFO_MAP.put((class_1299)class_7923.field_41177.method_10223(entityName), (TrainHatInfo)TrainHatInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)Create.LOGGER).error(arg_0)).orElseThrow());
            }
            catch (Exception e) {
                Create.LOGGER.error("Failed to read train hat info for entity {}!", (Object)entityName, (Object)e);
            }
        });
        Create.LOGGER.info("Loaded {} train hat configurations.", (Object)ENTITY_INFO_MAP.size());
    }

    public static TrainHatInfo getHatInfoFor(class_1299<?> type) {
        return ENTITY_INFO_MAP.getOrDefault(type, DEFAULT);
    }
}

