/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.TagValueAccessor;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TrackMaterialFactory {
    private final class_2960 id;
    private String langName;
    private NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock;
    private class_1856 sleeperIngredient = class_1856.field_9017;
    private class_1856 railsIngredient = class_1856.method_8092(Stream.of(TagValueAccessor.createTagValue(AllTags.forgeItemTag("iron_nuggets")), TagValueAccessor.createTagValue(AllTags.forgeItemTag("zinc_nuggets"))));
    private class_2960 particle;
    private TrackMaterial.TrackType trackType = TrackMaterial.TrackType.STANDARD;
    @Nullable
    private TrackMaterial.TrackType.TrackBlockFactory customFactory = null;
    @Environment(value=EnvType.CLIENT)
    private TrackMaterial.TrackModelHolder modelHolder;
    @Environment(value=EnvType.CLIENT)
    private PartialModel tieModel;
    @Environment(value=EnvType.CLIENT)
    private PartialModel leftSegmentModel;
    @Environment(value=EnvType.CLIENT)
    private PartialModel rightSegmentModel;

    public TrackMaterialFactory(class_2960 id) {
        this.id = id;
    }

    public static TrackMaterialFactory make(class_2960 id) {
        return new TrackMaterialFactory(id);
    }

    public TrackMaterialFactory lang(String langName) {
        this.langName = langName;
        return this;
    }

    public TrackMaterialFactory block(NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock) {
        this.trackBlock = trackBlock;
        return this;
    }

    public TrackMaterialFactory defaultModels() {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            this.modelHolder = TrackMaterial.TrackModelHolder.DEFAULT;
        });
        return this;
    }

    public TrackMaterialFactory sleeper(class_1856 sleeperIngredient) {
        this.sleeperIngredient = sleeperIngredient;
        return this;
    }

    public TrackMaterialFactory sleeper(class_1935 ... items) {
        this.sleeperIngredient = class_1856.method_8091((class_1935[])items);
        return this;
    }

    public TrackMaterialFactory rails(class_1856 railsIngredient) {
        this.railsIngredient = railsIngredient;
        return this;
    }

    public TrackMaterialFactory rails(class_1935 ... items) {
        this.railsIngredient = class_1856.method_8091((class_1935[])items);
        return this;
    }

    public TrackMaterialFactory noRecipeGen() {
        this.railsIngredient = class_1856.field_9017;
        this.sleeperIngredient = class_1856.field_9017;
        return this;
    }

    public TrackMaterialFactory particle(class_2960 particle) {
        this.particle = particle;
        return this;
    }

    public TrackMaterialFactory trackType(TrackMaterial.TrackType trackType) {
        this.trackType = trackType;
        return this;
    }

    public TrackMaterialFactory standardModels() {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            String namespace = this.id.method_12836();
            String prefix = "block/track/" + this.id.method_12832() + "/";
            this.tieModel = new PartialModel(new class_2960(namespace, prefix + "tie"));
            this.leftSegmentModel = new PartialModel(new class_2960(namespace, prefix + "segment_left"));
            this.rightSegmentModel = new PartialModel(new class_2960(namespace, prefix + "segment_right"));
        });
        return this;
    }

    public TrackMaterialFactory customModels(Supplier<Supplier<PartialModel>> tieModel, Supplier<Supplier<PartialModel>> leftSegmentModel, Supplier<Supplier<PartialModel>> rightSegmentModel) {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.lambda$customModels$4((Supplier)tieModel, (Supplier)leftSegmentModel, (Supplier)rightSegmentModel));
        return this;
    }

    public TrackMaterialFactory customBlockFactory(TrackMaterial.TrackType.TrackBlockFactory factory) {
        this.customFactory = factory;
        return this;
    }

    public TrackMaterial build() {
        assert (this.trackBlock != null);
        assert (this.langName != null);
        assert (this.particle != null);
        assert (this.trackType != null);
        assert (this.sleeperIngredient != null);
        assert (this.railsIngredient != null);
        assert (this.id != null);
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            assert (this.modelHolder != null);
            if (this.tieModel != null || this.leftSegmentModel != null || this.rightSegmentModel != null) {
                assert (this.tieModel != null && this.leftSegmentModel != null && this.rightSegmentModel != null);
                this.modelHolder = new TrackMaterial.TrackModelHolder(this.tieModel, this.leftSegmentModel, this.rightSegmentModel);
            }
        });
        return new TrackMaterial(this.id, this.langName, this.trackBlock, this.particle, this.sleeperIngredient, this.railsIngredient, this.trackType, () -> () -> this.modelHolder, this.customFactory);
    }

    private /* synthetic */ void lambda$customModels$4(Supplier tieModel, Supplier leftSegmentModel, Supplier rightSegmentModel) {
        this.tieModel = (PartialModel)((Supplier)tieModel.get()).get();
        this.leftSegmentModel = (PartialModel)((Supplier)leftSegmentModel.get()).get();
        this.rightSegmentModel = (PartialModel)((Supplier)rightSegmentModel.get()).get();
    }
}

