/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;

public final class ItemStackKey {
    private final class_1799 stack;
    private static final Map<class_1799, ItemStackKey> CACHE = new ConcurrentHashMap<class_1799, ItemStackKey>();
    private boolean hashInitialized = false;
    private int hash;

    public static ItemStackKey of(class_1799 stack) {
        return CACHE.computeIfAbsent(stack, ItemStackKey::new);
    }

    private ItemStackKey(class_1799 stack) {
        this.stack = stack.method_7972();
        this.stack.method_7939(1);
    }

    public static void clearCacheOnTickEnd() {
        CACHE.clear();
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemStackKey.canItemStacksStack(this.stack, that.stack);
    }

    public static boolean canItemStacksStack(class_1799 a, class_1799 b) {
        if (a.method_7960() || a.method_7909() != b.method_7909() || a.method_7985() != b.method_7985()) {
            return false;
        }
        return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
    }

    public boolean hashCodeNotEquals(class_1799 otherStack) {
        return this.hashCode() != ItemStackKey.getHashCode(otherStack);
    }

    public int hashCode() {
        if (!this.hashInitialized) {
            this.hashInitialized = true;
            this.hash = ItemStackKey.getHashCode(this.stack);
        }
        return this.hash;
    }

    public static int getHashCode(class_1799 stack) {
        int hash = stack.method_7909().hashCode();
        if (stack.method_7985()) {
            hash = hash * 31 + stack.method_7969().hashCode();
        }
        return hash;
    }

    public static int getHashCode(ItemVariant resource) {
        return ItemStackKey.getHashCode(resource.toStack());
    }

    public boolean matches(ItemVariant resource) {
        return this.hashCode() == ItemStackKey.getHashCode(resource);
    }

    public boolean matches(class_1799 stack) {
        return this.hashCode() == ItemStackKey.getHashCode(stack);
    }

    public class_1799 stack() {
        return this.stack;
    }

    public String toString() {
        return "ItemStackKey[stack=" + this.stack + "]";
    }
}

