/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.exposure;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.CapturedFramesHistory;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ClearRenderingCacheS2CP;
import io.github.mortuusars.exposure.network.packet.client.OnFrameAddedS2CP;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DebugCommand {
    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"clearRenderingCache").executes(DebugCommand::clearRenderingCache))).then(class_2170.method_9247((String)"chromaticFromLastThreeExposures").executes(DebugCommand::chromaticFromLastThreeExposures));
    }

    private static int clearRenderingCache(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 stack = (class_2168)context.getSource();
        class_3222 player = stack.method_9207();
        Packets.sendToClient(new ClearRenderingCacheS2CP(), player);
        return 0;
    }

    private static int chromaticFromLastThreeExposures(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 stack = (class_2168)context.getSource();
        class_3222 player = stack.method_9207();
        List<class_2487> frames = CapturedFramesHistory.get();
        if (frames.size() < 3) {
            stack.method_9213((class_2561)class_2561.method_43470((String)"Not enough frames were captured in this session. 3 is required."));
            return 1;
        }
        try {
            ChromaticSheetItem item = Exposure.Items.CHROMATIC_SHEET.get();
            class_1799 itemStack = new class_1799((class_1935)item);
            item.addExposure(itemStack, frames.get(2));
            item.addExposure(itemStack, frames.get(1));
            item.addExposure(itemStack, frames.get(0));
            class_1799 photographStack = item.finalize(player.method_37908(), itemStack, player.method_5820(), player);
            class_2487 frame = photographStack.method_7969();
            Preconditions.checkState((frame != null ? 1 : 0) != 0);
            Packets.sendToClient(new OnFrameAddedS2CP(frame), player);
            stack.method_9226(() -> class_2561.method_43470((String)("Created chromatic exposure: " + frame.method_10558("Id"))), true);
        }
        catch (Exception e) {
            stack.method_9213((class_2561)class_2561.method_43470((String)("Failed to create chromatic exposure: " + String.valueOf(e))));
            return 1;
        }
        return 0;
    }
}

