/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.fabric.integration.create;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.item.FilmRollItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import org.jetbrains.annotations.Nullable;

public class CreateFilmDeveloping {
    public static final String CURRENT_STEP_TAG = "CurrentDevelopingStep";
    private static final Map<FilmType, List<FluidStack>> cache = new HashMap<FilmType, List<FluidStack>>();

    public static SequencedAssemblyRecipe createSequencedDevelopingRecipe(FilmType filmType) {
        List<FluidStack> fillingSteps = CreateFilmDeveloping.getFillingSteps(filmType);
        SequencedAssemblyRecipeBuilder recipeBuilder = new SequencedAssemblyRecipeBuilder(Exposure.resource("sequenced_" + filmType.method_15434() + "_film_developing")).require((class_1935)filmType.createItemStack().method_7909()).transitionTo((class_1935)filmType.createItemStack().method_7909()).loops(1).addOutput((class_1935)filmType.createDevelopedItemStack().method_7909(), 1.0f);
        for (FluidStack fluidStack : fillingSteps) {
            recipeBuilder.addStep(FillingRecipe::new, f -> f.require(FluidIngredient.fromFluidStack((FluidStack)fluidStack)));
        }
        return recipeBuilder.build();
    }

    public static List<FluidStack> getFillingSteps(FilmType filmType) {
        if (cache.containsKey((Object)filmType)) {
            return cache.get((Object)filmType);
        }
        List steps = (List)Config.Common.spoutDevelopingSequence(filmType).get();
        List<FluidStack> fluidStacks = CreateFilmDeveloping.loadStacks(steps);
        if (!fluidStacks.isEmpty()) {
            cache.put(filmType, fluidStacks);
            return fluidStacks;
        }
        Exposure.LOGGER.warn("Create Film Developing should have at least one step. Defaults will be loaded.");
        List defaultSteps = (List)Config.Common.spoutDevelopingSequence(filmType).getDefault();
        List<FluidStack> defaultFluidStacks = CreateFilmDeveloping.loadStacks(defaultSteps);
        if (defaultFluidStacks.isEmpty()) {
            throw new IllegalStateException("Failed to load default fluid stacks. Something isn't right.");
        }
        cache.put(filmType, defaultFluidStacks);
        return defaultFluidStacks;
    }

    @Nullable
    public static FluidStack getNextRequiredFluid(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof FilmRollItem)) {
            throw new IllegalArgumentException("Filling to develop film can only be used on FilmRollItem. Got: " + String.valueOf(stack));
        }
        FilmRollItem filmRollItem = (FilmRollItem)class_17922;
        List<FluidStack> fillingSteps = CreateFilmDeveloping.getFillingSteps(filmRollItem.getType());
        class_2487 tag = stack.method_7969();
        if (tag == null || tag.method_33133()) {
            return fillingSteps.get(0);
        }
        int nextStep = tag.method_10550(CURRENT_STEP_TAG) + 1;
        if (nextStep > fillingSteps.size()) {
            return null;
        }
        return fillingSteps.get(Math.max(1, nextStep) - 1);
    }

    public static class_1799 fillFilmStack(class_1799 stack, long requiredAmount, FluidStack availableFluid) {
        class_1799 result;
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof FilmRollItem)) {
            throw new IllegalArgumentException("Filling to develop film can only be used on FilmRollItem. Got: " + String.valueOf(stack));
        }
        FilmRollItem filmRollItem = (FilmRollItem)class_17922;
        @Nullable FluidStack requiredFluid = CreateFilmDeveloping.getNextRequiredFluid(stack);
        if (requiredFluid == null) {
            throw new IllegalStateException("Cannot fill if fluid is not required anymore. This should have been handled in previous step.");
        }
        FilmType filmType = filmRollItem.getType();
        List<FluidStack> fillingSteps = CreateFilmDeveloping.getFillingSteps(filmType);
        int nextStep = CreateFilmDeveloping.getNextStep(stack);
        if (requiredAmount == 0L || nextStep == fillingSteps.size()) {
            result = filmType.createDevelopedItemStack();
            if (stack.method_7969() != null) {
                result.method_7980(stack.method_7948().method_10553());
            }
            result.method_7948().method_10551(CURRENT_STEP_TAG);
        } else {
            result = filmType.createItemStack();
            if (stack.method_7969() != null) {
                result.method_7980(stack.method_7948().method_10553());
            }
            result.method_7948().method_10569(CURRENT_STEP_TAG, nextStep);
        }
        availableFluid.shrink(requiredAmount);
        stack.method_7934(1);
        return result;
    }

    public static int getNextStep(class_1799 stack) {
        return stack.method_7969() != null ? stack.method_7969().method_10550(CURRENT_STEP_TAG) + 1 : 1;
    }

    public static void clearCachedData() {
        cache.clear();
    }

    private static List<FluidStack> loadStacks(List<? extends String> strings) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        for (String string : strings) {
            @Nullable FluidStack fluidStack = CreateFilmDeveloping.getFluidStack(string);
            if (fluidStack == null) continue;
            stacks.add(fluidStack);
        }
        return stacks;
    }

    @Nullable
    private static FluidStack getFluidStack(String serializedString) {
        try {
            class_2487 tag = class_2522.method_10718((String)serializedString);
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((class_2487)tag);
            if (!fluidStack.isEmpty()) {
                return fluidStack;
            }
            Exposure.LOGGER.warn("FluidStack [" + serializedString + "] was loaded empty.");
        }
        catch (CommandSyntaxException e) {
            Exposure.LOGGER.error("[" + serializedString + "] failed to load: " + String.valueOf((Object)e));
        }
        return null;
    }
}

