/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.base;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record HighlightLine(Vector3f start, Vector3f end, Vector3f normal) {
    public static final Codec<HighlightLine> CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> class_156.method_33141((List)floats, (int)6).map(HighlightLine::new), HighlightLine::getAsList);

    public HighlightLine(Vector3f start, Vector3f end) {
        this(start, end, HighlightLine.normal(start, end));
    }

    public HighlightLine(List<Float> list) {
        this(new Vector3f(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue()), new Vector3f(list.get(3).floatValue(), list.get(4).floatValue(), list.get(5).floatValue()));
    }

    public List<Float> getAsList() {
        return List.of(Float.valueOf(this.start.x()), Float.valueOf(this.start.y()), Float.valueOf(this.start.z()), Float.valueOf(this.end.x()), Float.valueOf(this.end.y()), Float.valueOf(this.end.z()));
    }

    public HighlightLine copy() {
        return new HighlightLine(new Vector3f((Vector3fc)this.start), new Vector3f((Vector3fc)this.end));
    }

    public void recalculateNormal() {
        Vector3f normal = HighlightLine.normal(this.start, this.end);
        this.normal.set(normal.x(), normal.y(), normal.z());
    }

    public void render(class_4587 poseStack, class_4588 consumer, float x, float y, float z) {
        class_4587.class_4665 last = poseStack.method_23760();
        consumer.method_22918(last.method_23761(), x + this.start.x(), y + this.start.y(), z + this.start.z()).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_23763(last.method_23762(), this.normal.x(), this.normal.y(), this.normal.z()).method_1344();
        consumer.method_22918(last.method_23761(), x + this.end.x(), y + this.end.y(), z + this.end.z()).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_23763(last.method_23762(), this.normal.x(), this.normal.y(), this.normal.z()).method_1344();
    }

    private static Vector3f normal(Vector3f start, Vector3f end) {
        Vector3f diff = new Vector3f(start.x() - end.x(), start.y() - end.y(), start.z() - end.z());
        float sqrt = class_3532.method_15355((float)(diff.x() * diff.x() + diff.y() * diff.y() + diff.z() * diff.z()));
        return new Vector3f(diff.x() / sqrt, diff.y() / sqrt, diff.z() / sqrt);
    }
}

