/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.conductor_possession;

import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.util.Utils;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_631.class}, priority=1200)
public abstract class ClientChunkCacheMixin {
    @Shadow
    volatile class_631.class_3681 field_16246;
    @Shadow
    @Final
    class_638 field_16525;

    private class_631.class_3681 newStorage(int viewDistance) {
        ClientChunkCacheMixin clientChunkCacheMixin = this;
        if (clientChunkCacheMixin instanceof class_631) {
            class_631 cache;
            class_631 class_6312 = cache = (class_631)clientChunkCacheMixin;
            Objects.requireNonNull(class_6312);
            return new class_631.class_3681(class_6312, viewDistance);
        }
        return null;
    }

    @Shadow
    private static boolean method_20181(class_2818 chunk, int x, int z) {
        throw new IllegalStateException("Shadowing isValidChunk did not work!");
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void railways$securitycraft$onInit(class_638 level, int viewDistance, CallbackInfo ci) {
        ConductorPossessionController.setCameraStorage(this.newStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"updateViewRadius"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;<init>(Lnet/minecraft/client/multiplayer/ClientChunkCache;I)V")})
    public void railways$securitycraft$onUpdateViewRadius(int viewDistance, CallbackInfo ci) {
        class_631.class_3681 oldStorage = ConductorPossessionController.getCameraStorage();
        class_631.class_3681 newStorage = this.newStorage(Math.max(2, viewDistance) + 3);
        newStorage.field_19204 = oldStorage.field_19204;
        newStorage.field_19205 = oldStorage.field_19205;
        for (int i = 0; i < oldStorage.field_16251.length(); ++i) {
            class_2818 chunk = (class_2818)oldStorage.field_16251.get(i);
            if (chunk == null) continue;
            class_1923 pos = chunk.method_12004();
            if (!newStorage.method_16034(pos.field_9181, pos.field_9180)) continue;
            newStorage.method_16031(newStorage.method_16027(pos.field_9181, pos.field_9180), chunk);
        }
        ConductorPossessionController.setCameraStorage(newStorage);
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void railways$securitycraft$onDrop(int x, int z, CallbackInfo ci) {
        int i;
        class_2818 chunk;
        class_631.class_3681 cameraStorage = ConductorPossessionController.getCameraStorage();
        if (cameraStorage.method_16034(x, z) && (chunk = cameraStorage.method_16033(i = cameraStorage.method_16027(x, z))) != null && chunk.method_12004().field_9181 == x && chunk.method_12004().field_9180 == z) {
            Utils.postChunkEventClient(chunk, false);
            cameraStorage.method_20183(i, chunk, null);
        }
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void railways$securitycraft$onReplace(int x, int z, class_2540 buffer, class_2487 chunkTag, Consumer<class_6603.class_6605> tagOutputConsumer, CallbackInfoReturnable<class_2818> callback) {
        class_631.class_3681 cameraStorage = ConductorPossessionController.getCameraStorage();
        if (ClientHandler.isPlayerMountedOnCamera() && cameraStorage.method_16034(x, z)) {
            int index = cameraStorage.method_16027(x, z);
            class_2818 chunk = cameraStorage.method_16033(index);
            class_1923 chunkPos = new class_1923(x, z);
            if (!ClientChunkCacheMixin.method_20181(chunk, x, z)) {
                chunk = new class_2818((class_1937)this.field_16525, chunkPos);
                chunk.method_12224(buffer, chunkTag, tagOutputConsumer);
                cameraStorage.method_16031(index, chunk);
            } else {
                chunk.method_12224(buffer, chunkTag, tagOutputConsumer);
            }
            this.field_16525.method_23782(chunkPos);
            Utils.postChunkEventClient(chunk, true);
            callback.setReturnValue((Object)chunk);
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, slice={@Slice(from=@At(value="RETURN", ordinal=1))}, at={@At(value="RETURN")}, cancellable=true)
    private void railways$securitycraft$onGetChunk(int x, int z, class_2806 requiredStatus, boolean load, CallbackInfoReturnable<class_2818> callback) {
        class_2818 chunk;
        if (ClientHandler.isPlayerMountedOnCamera() && ConductorPossessionController.getCameraStorage().method_16034(x, z) && (chunk = ConductorPossessionController.getCameraStorage().method_16033(ConductorPossessionController.getCameraStorage().method_16027(x, z))) != null && chunk.method_12004().field_9181 == x && chunk.method_12004().field_9180 == z) {
            callback.setReturnValue((Object)chunk);
        }
    }
}

