/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import quek.undergarden.block.entity.DepthrockBedBlockEntity;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.registry.UGBlockEntities;

public class DepthrockBedRender
implements BlockEntityRenderer<DepthrockBedBlockEntity> {
    private final ModelPart headPiece;
    private final ModelPart footPiece;

    public DepthrockBedRender(BlockEntityRendererProvider.Context renderContext) {
        this.headPiece = renderContext.m_173582_(UGModelLayers.DEPTHROCK_BED_HEAD);
        this.footPiece = renderContext.m_173582_(UGModelLayers.DEPTHROCK_BED_FOOT);
    }

    public static LayerDefinition createHeadLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 9.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createFootLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("foot", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 9.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(DepthrockBedBlockEntity bed, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level = bed.m_58904_();
        if (level != null) {
            BlockState blockstate = bed.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult neighborCombineResult = DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)UGBlockEntities.DEPTHROCK_BED.get()), BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)bed.m_58899_(), (levelAccessor, pos) -> false);
            int i = ((Int2IntFunction)neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(combinedLight);
            this.renderPiece(poseStack, buffer, blockstate.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? this.headPiece : this.footPiece, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), i, combinedOverlay, false);
        } else {
            this.renderPiece(poseStack, buffer, this.headPiece, Direction.SOUTH, combinedLight, combinedOverlay, false);
            this.renderPiece(poseStack, buffer, this.footPiece, Direction.SOUTH, combinedLight, combinedOverlay, true);
        }
    }

    private void renderPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, ModelPart bedPart, Direction direction, int combinedLight, int combinedOverlay, boolean isBedFoot) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, isBedFoot ? -1.0 : 0.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + direction.m_122435_()));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)new ResourceLocation("undergarden", "textures/block/depthrock_bed.png")));
        bedPart.m_104301_(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.m_85849_();
    }
}

