/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class UGItemModelProvider
extends ItemModelProvider {
    public UGItemModelProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "undergarden", fileHelper);
    }

    private String blockName(Supplier<? extends Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_();
    }

    private ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public void itemFence(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", "block/" + name);
    }

    public ItemModelBuilder block(Supplier<? extends Block> block) {
        return this.block(block, this.blockName(block));
    }

    public ItemModelBuilder block(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.modLoc("block/" + name));
    }

    public void blockFlat(Supplier<? extends Block> block) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + this.blockName(block)));
    }

    public void blockFlatWithBlockTexture(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + name))).renderType("translucent");
    }

    public void blockFlatWithItemTexture(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    public void normalItem(Supplier<? extends Item> item) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_()));
    }

    public void torchItem(Supplier<? extends Block> item) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)item.get()).m_135815_()));
    }

    public void toolItem(Supplier<? extends Item> item) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_()));
    }

    public void rodItem(Supplier<? extends Item> item) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/handheld_rod"))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_()));
    }

    public void egg(Supplier<? extends Item> item) {
        this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    public void sign(Supplier<? extends SignBlock> sign) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(sign), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + this.blockName(sign)));
    }

    public ItemModelBuilder wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(ForgeRegistries.BLOCKS.getKey((Object)((Block)wall.get())).m_135815_(), this.texture(this.blockName(fullBlock)));
    }

    public ItemModelBuilder button(Supplier<? extends ButtonBlock> button, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.buttonInventory(ForgeRegistries.BLOCKS.getKey((Object)((Block)button.get())).m_135815_(), this.texture(this.blockName(fullBlock)));
    }
}

