/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectSortedMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;

public class ChunkRenderList {
    private final Reference2ObjectLinkedOpenHashMap<RenderRegion, List<RenderSection>> entries = new Reference2ObjectLinkedOpenHashMap();

    public Iterable<Map.Entry<RenderRegion, List<RenderSection>>> sorted(boolean reverse) {
        if (this.entries.isEmpty()) {
            return Collections.emptyList();
        }
        final Reference2ObjectSortedMap.FastSortedEntrySet entries = this.entries.reference2ObjectEntrySet();
        if (reverse) {
            return () -> new Iterator<Map.Entry<RenderRegion, List<RenderSection>>>(){
                final ObjectBidirectionalIterator<Reference2ObjectMap.Entry<RenderRegion, List<RenderSection>>> iterator;
                {
                    this.iterator = entries.fastIterator((Reference2ObjectMap.Entry)entries.last());
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasPrevious();
                }

                @Override
                public Map.Entry<RenderRegion, List<RenderSection>> next() {
                    return (Map.Entry)this.iterator.previous();
                }
            };
        }
        return () -> new Iterator<Map.Entry<RenderRegion, List<RenderSection>>>(){
            final ObjectBidirectionalIterator<Reference2ObjectMap.Entry<RenderRegion, List<RenderSection>>> iterator;
            {
                this.iterator = entries.fastIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<RenderRegion, List<RenderSection>> next() {
                return (Map.Entry)this.iterator.next();
            }
        };
    }

    public void clear() {
        this.entries.clear();
    }

    public void markRegion(RenderRegion region) {
        this.entries.computeIfAbsent((Object)region, key -> new ObjectArrayList());
    }

    public void add(RenderSection render) {
        RenderRegion region = render.getRegion();
        List sections = (List)this.entries.computeIfAbsent((Object)region, key -> new ObjectArrayList());
        sections.add(render);
    }

    public int getCount() {
        return this.entries.values().stream().mapToInt(List::size).sum();
    }
}

