/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCategoryIconUtil;
import mezz.jei.gui.recipes.RecipeGuiTab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory<?> category;
    private final IRecipeManager recipeManager;
    private final IGuiHelper guiHelper;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, int x, int y, IRecipeManager recipeManager, IGuiHelper guiHelper) {
        super(x, y);
        this.logic = logic;
        this.category = category;
        this.recipeManager = recipeManager;
        this.guiHelper = guiHelper;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (!this.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return Optional.empty();
        }
        if (input.is(keyBindings.getLeftClick())) {
            if (!input.isSimulate()) {
                this.logic.setRecipeCategory(this.category);
                SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
                soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public void draw(boolean selected, PoseStack poseStack, int mouseX, int mouseY) {
        super.draw(selected, poseStack, mouseX, mouseY);
        IDrawable icon = RecipeCategoryIconUtil.create(this.category, this.recipeManager, this.guiHelper);
        int iconX = this.x + (24 - icon.getWidth()) / 2;
        int iconY = this.y + (24 - icon.getHeight()) / 2;
        icon.draw(poseStack, iconX, iconY);
    }

    @Override
    public boolean isSelected(IRecipeCategory<?> selectedCategory) {
        return this.category.getRecipeType().equals(selectedCategory.getRecipeType());
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Component title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        ResourceLocation uid = this.category.getRecipeType().getUid();
        String modId = uid.m_135827_();
        IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add((Component)Component.m_237113_((String)modName));
        }
        return tooltip;
    }
}

