/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;

public class ProbeConfig {
    public static ProbeConfig INSTANCE = new ProbeConfig();
    private static final int CONFIG_VERSION = 1;
    public boolean firstLoad = true;
    public boolean noAggressiveProbing = false;
    public long docsTimestamp = 0L;
    public boolean allowRegistryObjectDumps = false;
    public boolean requireSingleAndPerm = true;
    public boolean enabled = true;
    public boolean disableRecipeJsonDump = false;
    public boolean dumpJSONIntermediates = false;

    private static <E> E fetchPropertyOrDefault(Object key, Map<?, ?> value, E defaultValue) {
        if (value == null || !value.containsKey("version") || (Double)value.get("version") < 1.0) {
            ProbeJS.LOGGER.warn("Config version has changed! Config values are rolled back to default.");
            return defaultValue;
        }
        Object v = value.get(key);
        return (E)(v == null ? defaultValue : v);
    }

    private ProbeConfig() {
        Path cfg = KubeJSPaths.CONFIG.resolve("probejs.json");
        if (Files.exists(cfg, new LinkOption[0])) {
            try {
                Map obj = (Map)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cfg), Map.class);
                this.firstLoad = ProbeConfig.fetchPropertyOrDefault("firstLoad", obj, true);
                this.noAggressiveProbing = ProbeConfig.fetchPropertyOrDefault("noAggressiveProbing", obj, false);
                this.docsTimestamp = ProbeConfig.fetchPropertyOrDefault("docsTimestamp", obj, 0.0).longValue();
                this.allowRegistryObjectDumps = ProbeConfig.fetchPropertyOrDefault("allowRegistryObjectDumps", obj, false);
                this.requireSingleAndPerm = ProbeConfig.fetchPropertyOrDefault("requireSingleAndPerm", obj, true);
                this.enabled = ProbeConfig.fetchPropertyOrDefault("enabled", obj, true);
                this.disableRecipeJsonDump = ProbeConfig.fetchPropertyOrDefault("disableRecipeJsonDump", obj, false);
                this.dumpJSONIntermediates = ProbeConfig.fetchPropertyOrDefault("dumpJSONIntermediates", obj, false);
            }
            catch (IOException e) {
                ProbeJS.LOGGER.warn("Cannot read config properties, falling back to defaults.");
            }
        }
        this.save();
    }

    public void save() {
        Path cfg = KubeJSPaths.CONFIG.resolve("probejs.json");
        try (BufferedWriter writer = Files.newBufferedWriter(cfg, new OpenOption[0]);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject jObj = gson.toJsonTree((Object)this).getAsJsonObject();
            jObj.addProperty("version", (Number)1);
            gson.toJson((JsonElement)jObj, (Appendable)writer);
        }
        catch (IOException e) {
            ProbeJS.LOGGER.warn("Cannot write config, settings are not saved.");
        }
    }

    public boolean toggleAggressiveProbing() {
        this.noAggressiveProbing = !this.noAggressiveProbing;
        return this.noAggressiveProbing;
    }

    public boolean shouldProbingAggressive() {
        return !this.noAggressiveProbing && this.enabled;
    }

    public static String getModHash() {
        Path hashFile = ProbePaths.CACHE.resolve("modHash.txt");
        if (Files.exists(hashFile, new LinkOption[0])) {
            try {
                return Files.readString(hashFile);
            }
            catch (IOException e) {
                ProbeJS.LOGGER.warn("Cannot read mod hash file, falling back to default.");
            }
        }
        return "0";
    }

    public static void writeModHash(String hash) {
        Path hashFile = ProbePaths.CACHE.resolve("modHash.txt");
        try {
            Files.writeString(hashFile, (CharSequence)hash, new OpenOption[0]);
        }
        catch (IOException e) {
            ProbeJS.LOGGER.warn("Cannot write mod hash file, settings are not saved.");
        }
    }
}

