/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.probejs.ProbeCommands;
import com.probejs.ProbeConfig;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ProbeJSEvents {
    private static void computeKubeJSObjectHash(MessageDigest digest) {
        RegistryInfo.MAP.values().stream().flatMap(info -> info.objects.keySet().stream().map(ResourceLocation::toString).map(s -> info.key.m_135782_() + "/" + s)).sorted().forEach(key -> digest.update(key.getBytes()));
    }

    private static void computeModHash(Mod mod, MessageDigest digest) {
        String idVersion = mod.getModId() + mod.getVersion();
        digest.update(idVersion.getBytes());
    }

    private static String byte2Hex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void playerJoined(ServerPlayer player) {
        if (player.f_8924_.m_129792_() && player.m_20310_(2)) {
            if (!ProbeConfig.INSTANCE.shouldProbingAggressive()) {
                return;
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                for (Mod mod : Platform.getMods().stream().sorted(Comparator.comparing(Mod::getModId)).toList()) {
                    ProbeJSEvents.computeModHash(mod, digest);
                }
                ProbeJSEvents.computeKubeJSObjectHash(digest);
                String hash = ProbeJSEvents.byte2Hex(digest.digest());
                if (!hash.equals(ProbeConfig.getModHash())) {
                    ProbeConfig.writeModHash(hash);
                    player.m_213846_((Component)Component.m_237113_((String)"Mod list has changed, dumping new docs..."));
                    ProbeCommands.triggerDump(player);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (ProbeConfig.INSTANCE.firstLoad) {
                player.m_213846_((Component)Component.m_237113_((String)"This is the first time you are running ProbeJS. An automatic dump will be triggered."));
                player.m_213846_((Component)Component.m_237113_((String)"The aggressive mode will be turned off, you can still turn it on by ").m_7220_((Component)Component.m_237113_((String)"/probejs configure toggle_aggressive").kjs$underlined().kjs$green().kjs$clickSuggestCommand("/probejs configure toggle_aggressive")).m_7220_((Component)Component.m_237113_((String)" later.").kjs$white()));
                ProbeConfig.INSTANCE.noAggressiveProbing = true;
                ProbeConfig.INSTANCE.firstLoad = false;
                ProbeConfig.INSTANCE.save();
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Aggressive probing is on. Remember to disable it in release!").kjs$red().kjs$underlined());
                player.m_213846_((Component)Component.m_237113_((String)"Use ").m_7220_((Component)Component.m_237113_((String)"/probejs configure toggle_aggressive").kjs$underlined().kjs$green().kjs$clickSuggestCommand("/probejs configure toggle_aggressive")).m_7220_((Component)Component.m_237113_((String)" to disable.").kjs$white()));
            }
        }
    }
}

