/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.mojang.datafixers.util.Pair;
import com.probejs.ProbePaths;
import com.probejs.compiler.RegistryCompiler;
import com.probejs.compiler.TagEventCompiler;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.java.ClassInfo;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.jdoc.property.PropertyExtra;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EventCompiler {
    public static Map<Pair<String, String>, Function<EventHandler, List<String>>> SPECIAL_EVENT_OVERRIDE = new HashMap<Pair<String, String>, Function<EventHandler, List<String>>>();

    public static void initSpecialEvents() {
        SPECIAL_EVENT_OVERRIDE.put((Pair<String, String>)new Pair((Object)"StartupEvents", (Object)"registry"), handler -> RegistryCompiler.getRegistryEventOverrides());
        SPECIAL_EVENT_OVERRIDE.put((Pair<String, String>)new Pair((Object)"ServerEvents", (Object)"tags"), handler -> TagEventCompiler.getTagEventOverrides());
    }

    public static List<Class<?>> fetchEventClasses() {
        return EventGroup.getGroups().values().stream().map(EventGroup::getHandlers).map(Map::values).flatMap(Collection::stream).map(handler -> (Class)handler.eventType.get()).collect(Collectors.toList());
    }

    private static <T extends AbstractProperty<T>> Optional<T> findProperty(Map<String, DocumentClass> globalClasses, DocumentClass documentClass, Class<T> propertyClass) {
        Optional<T> result = documentClass.findProperty(propertyClass);
        if (result.isPresent()) {
            return result;
        }
        String parent = PropertyType.getClazzName(documentClass.getParent()).orElse(null);
        if (parent != null && globalClasses.containsKey(parent)) {
            return EventCompiler.findProperty(globalClasses, globalClasses.get(parent), propertyClass);
        }
        for (PropertyType<?> type : documentClass.getInterfaces()) {
            Optional<T> found;
            String implemented = PropertyType.getClazzName(type).orElse(null);
            if (implemented == null || !globalClasses.containsKey(implemented) || !(found = EventCompiler.findProperty(globalClasses, globalClasses.get(implemented), propertyClass)).isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    public static void compileEvents(Map<String, DocumentClass> globalClasses) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("events.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        writer.write("/// <reference path=\"./registries.d.ts\" />\n");
        for (Map.Entry entry : EventGroup.getGroups().entrySet()) {
            String name = (String)entry.getKey();
            EventGroup group = (EventGroup)entry.getValue();
            ArrayList<String> elements = new ArrayList<String>();
            elements.add("{");
            for (Map.Entry e : group.getHandlers().entrySet()) {
                String eventName = (String)e.getKey();
                EventHandler handler = (EventHandler)e.getValue();
                Class event = (Class)handler.eventType.get();
                ClassInfo eventType = ClassInfo.getOrCache(event);
                Function<EventHandler, List<String>> specialHandler = SPECIAL_EVENT_OVERRIDE.get(new Pair((Object)name, (Object)eventName));
                if (specialHandler != null) {
                    elements.addAll((Collection)specialHandler.apply(handler));
                    continue;
                }
                DocumentClass document = globalClasses.get(eventType.getName());
                PropertyComment comment = document.getMergedComment().merge(new PropertyComment("@at *%s*".formatted(handler.scriptTypePredicate.getValidTypes().stream().map(type -> type.name).collect(Collectors.joining(", ")))));
                if (handler.getHasResult()) {
                    comment = comment.merge(new PropertyComment("@cancellable"));
                }
                elements.addAll(comment.formatLines(4));
                if (handler.extra != null) {
                    elements.add("%s(extra: %s, handler: (event: %s) => void):void,".formatted(eventName, EventCompiler.findProperty(globalClasses, document, PropertyExtra.class).map(extra -> Serde.getTypeFormatter(extra.getType()).formatFirst()).orElse("string"), Util.formatMaybeParameterized(event)));
                }
                if (handler.extra != null && handler.extra.required) continue;
                elements.add("%s(handler: (event: %s) => void):void,".formatted(eventName, Util.formatMaybeParameterized(event)));
            }
            elements.add("};\n");
            writer.write("declare const %s: %s".formatted(name, String.join((CharSequence)"\n", elements)));
        }
        writer.close();
    }
}

