/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.compiler.formatter.formatter.FormatterNamespace;
import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.util.RLHelper;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.RegistryEventJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class RegistryCompiler {
    public static Set<Class<?>> getKJSRegistryClasses() {
        HashSet result = new HashSet();
        result.add(RegistryInfo.class);
        result.add(RegistryEventJS.class);
        RegistryInfo.MAP.values().forEach(v -> v.types.values().forEach(v1 -> result.add(v1.builderClass())));
        return result;
    }

    public static void compileRegistryEvents() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("registries.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        FormatterNamespace namespace = new FormatterNamespace("Registry", RegistryInfo.MAP.values().stream().map(FormatterRegistry::new).collect(Collectors.toList()));
        writer.write(String.join((CharSequence)"\n", namespace.format(0, 4)));
        writer.close();
    }

    public static List<String> getRegistryEventOverrides() {
        ArrayList<String> lines = new ArrayList<String>();
        for (RegistryInfo types : RegistryInfo.MAP.values()) {
            ResourceLocation loc = types.key.m_135782_();
            String registryName = FormatterRegistry.getFormattedRegistryName(types);
            lines.add("registry(type: %s, handler: (event: Registry.%s) => void):void,".formatted(ProbeJS.GSON.toJson((Object)loc.toString()), registryName));
            if (!loc.m_135827_().equals("minecraft")) continue;
            String shortName = loc.m_135815_().replace('/', '.');
            lines.add("registry(type: %s, handler: (event: Registry.%s) => void):void,".formatted(ProbeJS.GSON.toJson((Object)shortName), registryName));
        }
        return lines;
    }

    public static class FormatterRegistry
    implements IFormatter {
        RegistryInfo types;
        String name;

        public static String getFormattedRegistryName(RegistryInfo types) {
            return RLHelper.rlToTitle(types.key.m_135782_().m_135815_());
        }

        private FormatterRegistry(RegistryInfo types) {
            this.types = types;
            this.name = FormatterRegistry.getFormattedRegistryName(types);
        }

        @Override
        public List<String> format(Integer indent, Integer stepIndent) {
            ArrayList<String> formatted = new ArrayList<String>();
            int stepped = indent + stepIndent;
            formatted.add(" ".repeat(indent) + "class %s extends %s {".formatted(this.name, Util.formatMaybeParameterized(RegistryEventJS.class)));
            for (BuilderType builder : this.types.types.values()) {
                formatted.add(" ".repeat(stepped) + "create(id: string, type: %s): %s;".formatted(ProbeJS.GSON.toJson((Object)builder.type()), Util.formatMaybeParameterized(builder.builderClass())));
            }
            if (this.types.getDefaultType() != null) {
                formatted.add(" ".repeat(stepped) + "create(id: string): %s;".formatted(Util.formatMaybeParameterized(this.types.getDefaultType().builderClass())));
            }
            formatted.add(" ".repeat(indent) + "}");
            return formatted;
        }
    }
}

