/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.compiler.formatter.formatter.FormatterNamespace;
import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.util.RLHelper;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.server.tag.TagEventJS;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;

public class TagEventCompiler {
    public static void compileTagEvents() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("tag_events.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        FormatterNamespace namespace = new FormatterNamespace("TagEvent", ProbeCommands.COMMAND_LEVEL.m_5962_().m_206193_().map(RegistryAccess.RegistryEntry::f_206233_).map(r -> new FormatterTagEvent((ResourceKey<Registry<?>>)r)).collect(Collectors.toList()));
        writer.write(String.join((CharSequence)"\n", namespace.format(0, 4)));
        writer.close();
    }

    public static List<String> getTagEventOverrides() {
        ArrayList<String> lines = new ArrayList<String>();
        ProbeCommands.COMMAND_LEVEL.m_5962_().m_206193_().forEach(entry -> {
            if (entry.f_206234_().m_203613_().findAny().isEmpty()) {
                return;
            }
            ResourceKey registry = entry.f_206233_();
            if (registry.m_135782_().m_135827_().equals("minecraft")) {
                lines.add("tags(type: %s, handler: (event: TagEvent.%s) => void): void".formatted(ProbeJS.GSON.toJson((Object)registry.m_135782_().m_135815_()), RLHelper.finalComponentToTitle(registry.m_135782_().m_135815_())));
            }
            lines.add("tags(type: %s, handler: (event: TagEvent.%s) => void): void".formatted(ProbeJS.GSON.toJson((Object)registry.m_135782_().toString()), RLHelper.finalComponentToTitle(registry.m_135782_().m_135815_())));
        });
        return lines;
    }

    public static class FormatterTagEvent
    implements IFormatter {
        private final ResourceKey<Registry<?>> registry;

        public FormatterTagEvent(ResourceKey<Registry<?>> registry) {
            this.registry = registry;
        }

        @Override
        public List<String> format(Integer indent, Integer stepIndent) {
            ArrayList<String> formatted = new ArrayList<String>();
            String capitalized = RLHelper.finalComponentToTitle(this.registry.m_135782_().m_135815_());
            String specialType = "Special.%s".formatted(capitalized);
            String tagType = specialType + "Tag";
            String wrapperType = Util.formatMaybeParameterized(TagWrapper.class);
            formatted.add("%sclass %s extends %s {".formatted(" ".repeat(indent), capitalized, Util.formatMaybeParameterized(TagEventJS.class)));
            formatted.add("%sget(id: %s): %s".formatted(" ".repeat(indent), tagType, wrapperType));
            formatted.add("%sadd(tag: %s, ...id: %s[]): %s".formatted(" ".repeat(indent), tagType, specialType, wrapperType));
            formatted.add("%sremove(tag: %s, ...id: %s[]): %s".formatted(" ".repeat(indent), tagType, specialType, wrapperType));
            formatted.add("%sremoveAll(tag: %s): %s".formatted(" ".repeat(indent), tagType, wrapperType));
            formatted.add("%sremoveAllTagsFrom(...id: %s[]): %s".formatted(" ".repeat(indent), specialType, wrapperType));
            formatted.add(" ".repeat(indent) + "}");
            return formatted;
        }
    }
}

