/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler.formatter;

import com.google.gson.Gson;
import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.compiler.SpecialCompiler;
import com.probejs.compiler.formatter.NameResolver;
import com.probejs.compiler.formatter.formatter.special.FormatterRegistry;
import com.probejs.util.RLHelper;
import dev.latvian.mods.rhino.util.EnumTypeWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class SpecialTypes {
    public static Map<Class<?>, ResourceKey<?>> registryAssignments = new HashMap();

    public static void processEnums(Set<Class<?>> globalClasses) {
        for (Class<?> clazz : globalClasses) {
            if (!clazz.isEnum()) continue;
            try {
                EnumTypeWrapper wrapper = EnumTypeWrapper.get(clazz);
                NameResolver.putSpecialAssignments(clazz, () -> wrapper.nameValues.keySet().stream().map(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0)).collect(Collectors.toList()));
            }
            catch (Throwable e) {
                ProbeJS.LOGGER.warn("Failed to process enum: %s".formatted(clazz.getName()));
            }
        }
    }

    public static <T> void assignRegistry(Class<T> clazz, ResourceKey<Registry<T>> resourceKey) {
        SpecialCompiler.specialCompilers.add(new FormatterRegistry<T>(resourceKey));
        NameResolver.putSpecialAssignments(clazz, () -> List.of("Special.%s".formatted(RLHelper.finalComponentToTitle(resourceKey.m_135782_().m_135815_()))));
        registryAssignments.put(clazz, resourceKey);
    }

    public static String getRegistryTagName(Class<?> clazz) {
        ResourceKey<?> key = registryAssignments.get(clazz);
        if (key == null) {
            return null;
        }
        return "`#${Special.%sTag}`".formatted(RLHelper.finalComponentToTitle(key.m_135782_().m_135815_()));
    }

    private static List<Class<?>> getParentInterfaces(List<Class<?>> putative, Class<?> o) {
        ArrayList result = new ArrayList();
        for (Class<?> clazz : putative) {
            if (!clazz.isAssignableFrom(o)) {
                result.addAll(SpecialTypes.getParentInterfaces(List.of(clazz.getInterfaces()), o));
                continue;
            }
            result.add(clazz);
        }
        return result;
    }

    public static <T> void assignRegistries() {
        ProbeCommands.COMMAND_LEVEL.m_5962_().m_206193_().forEach(entry -> {
            ResourceKey key = entry.f_206233_();
            Registry registry = entry.f_206234_();
            Class<Object> putativeParent = null;
            for (Object o : registry) {
                if (putativeParent == null) {
                    putativeParent = o.getClass();
                    continue;
                }
                while (!putativeParent.isAssignableFrom(o.getClass())) {
                    putativeParent = putativeParent.getSuperclass();
                }
            }
            if (putativeParent == null) {
                return;
            }
            while (putativeParent.isSynthetic()) {
                putativeParent = putativeParent.getSuperclass();
            }
            if (putativeParent == Object.class) {
                List<Class<?>> putativeInterfaces = new ArrayList();
                for (Object o : registry) {
                    if (putativeInterfaces.isEmpty()) {
                        putativeInterfaces.addAll(List.of(o.getClass().getInterfaces()));
                        continue;
                    }
                    putativeInterfaces = SpecialTypes.getParentInterfaces(putativeInterfaces, o.getClass());
                }
                if (!putativeInterfaces.isEmpty()) {
                    putativeParent = (Class)putativeInterfaces.get(0);
                }
            }
            SpecialTypes.assignRegistry(putativeParent, key);
        });
    }

    public static List<Class<?>> collectRegistryClasses() {
        ArrayList classes = new ArrayList();
        ProbeCommands.COMMAND_LEVEL.m_5962_().m_206193_().forEach(entry -> {
            Registry registry = entry.f_206234_();
            for (Object o : registry) {
                Class<?> clazz = o.getClass();
                if (clazz.isSynthetic()) continue;
                classes.add(o.getClass());
            }
        });
        return classes.stream().limit(32768L).collect(Collectors.toList());
    }
}

