/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler.formatter.formatter.jdoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.probejs.compiler.formatter.NameResolver;
import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.compiler.formatter.formatter.jdoc.DocumentFormatter;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterConstructor;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterField;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterMethod;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.document.DocumentConstructor;
import com.probejs.jdoc.document.DocumentField;
import com.probejs.jdoc.document.DocumentMethod;
import com.probejs.jdoc.property.PropertyAssign;
import com.probejs.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FormatterClass
extends DocumentFormatter<DocumentClass> {
    public static Multimap<String, Function<DocumentClass, IFormatter>> SPECIAL_FORMATTER_REGISTRY = ArrayListMultimap.create();
    private boolean internal = false;

    public FormatterClass(DocumentClass document) {
        super(document.applyProperties());
    }

    public String getClassGeneric() {
        if (((DocumentClass)this.document).getGenerics().isEmpty()) {
            return "";
        }
        return "<%s>".formatted(((DocumentClass)this.document).getGenerics().stream().map(Serde::getTypeFormatter).map(IFormatter::formatParamVariable).collect(Collectors.joining(", ")));
    }

    public String getTypeClassGeneric() {
        if (((DocumentClass)this.document).getGenerics().isEmpty()) {
            return "";
        }
        return "<%s>".formatted(((DocumentClass)this.document).getGenerics().stream().map(Serde::getTypeFormatter).map(IFormatter::formatFirst).collect(Collectors.joining(", ")));
    }

    @Override
    public List<String> formatDocument(Integer indent, Integer stepIndent) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder header = new StringBuilder();
        if (!this.internal) {
            header.append("declare ");
        }
        if (((DocumentClass)this.document).isAbstract() && !((DocumentClass)this.document).isInterface()) {
            header.append("abstract ");
        }
        header.append(((DocumentClass)this.document).isInterface() ? "interface" : "class");
        header.append(" %s ".formatted(NameResolver.getResolvedName(((DocumentClass)this.document).getName()).getLastName()));
        if (!((DocumentClass)this.document).getGenerics().isEmpty()) {
            header.append("<%s> ".formatted(((DocumentClass)this.document).getGenerics().stream().map(Serde::getTypeFormatter).map(IFormatter::formatClassVariable).collect(Collectors.joining(", "))));
        }
        if (!((DocumentClass)this.document).isInterface()) {
            if (((DocumentClass)this.document).getParent() != null) {
                header.append("extends %s ".formatted(Serde.getTypeFormatter(((DocumentClass)this.document).getParent()).formatParamVariable()));
            }
            if (!((DocumentClass)this.document).getInterfaces().isEmpty()) {
                header.append("implements %s ".formatted(((DocumentClass)this.document).getInterfaces().stream().map(Serde::getTypeFormatter).map(IFormatter::formatParamVariable).collect(Collectors.joining(", "))));
            }
        } else {
            ArrayList parents = new ArrayList();
            if (((DocumentClass)this.document).getParent() != null) {
                parents.add(((DocumentClass)this.document).getParent());
            }
            if (!((DocumentClass)this.document).getInterfaces().isEmpty()) {
                parents.addAll(((DocumentClass)this.document).getInterfaces());
            }
            if (!parents.isEmpty()) {
                header.append("extends %s ".formatted(parents.stream().map(Serde::getTypeFormatter).map(IFormatter::formatParamVariable).collect(Collectors.joining(", "))));
            }
        }
        header.append("{");
        lines.add(Util.indent(indent) + header);
        ((DocumentClass)this.document).getConstructors().stream().map(DocumentConstructor::applyProperties).forEach(constructor -> lines.addAll(new FormatterConstructor((DocumentConstructor)constructor).format(indent + stepIndent, stepIndent)));
        ((DocumentClass)this.document).getMethods().stream().map(DocumentMethod::applyProperties).forEach(method -> lines.addAll(new FormatterMethod((DocumentMethod)method, (DocumentClass)this.document).format(indent + stepIndent, stepIndent)));
        ((DocumentClass)this.document).getMethods().stream().map(DocumentMethod::applyProperties).map(method -> new FormatterMethod((DocumentMethod)method, (DocumentClass)this.document)).map(FormatterMethod::getBeanFormatter).filter(Optional::isPresent).map(Optional::get).forEach(formatter -> lines.addAll(formatter.format(indent + stepIndent, stepIndent)));
        if (((DocumentClass)this.document).isFunctionalInterface() && ((DocumentClass)this.document).methods.stream().filter(method -> method.isAbstract).count() == 1L) {
            FormatterMethod hybridFormatter = new FormatterMethod(((DocumentClass)this.document).methods.stream().filter(method -> method.isAbstract).findFirst().get(), (DocumentClass)this.document);
            hybridFormatter.setFunctionalInterface(true);
            lines.add("%s%s;".formatted(" ".repeat(indent + stepIndent), hybridFormatter.formatMethodParts()));
        }
        ((DocumentClass)this.document).getFields().stream().map(DocumentField::applyProperties).forEach(field -> lines.addAll(new FormatterField((DocumentField)field).setInterface(((DocumentClass)this.document).isInterface()).format(indent + stepIndent, stepIndent)));
        lines.add(Util.indent(indent) + "}");
        HashSet<Object> typesAssignable = new HashSet<Object>();
        String typeName = NameResolver.getResolvedName(((DocumentClass)this.document).getName()).getLastName();
        if (((DocumentClass)this.document).findPropertiesOf(PropertyAssign.class).stream().noneMatch(PropertyAssign::isShieldOriginal)) {
            typesAssignable.add(typeName + this.getClassGeneric());
        }
        ((DocumentClass)this.document).findPropertiesOf(PropertyAssign.class).forEach(property -> typesAssignable.add(Serde.getTypeFormatter(property.getType()).underscored().formatParamVariable()));
        for (Function formatter2 : SPECIAL_FORMATTER_REGISTRY.get((Object)((DocumentClass)this.document).getName())) {
            typesAssignable.add(((IFormatter)formatter2.apply((DocumentClass)this.document)).formatFirst());
        }
        typesAssignable.addAll(NameResolver.getClassAssignments(((DocumentClass)this.document).getName()));
        lines.add(Util.indent(indent) + "type %s_%s = %s;".formatted(typeName, this.getTypeClassGeneric(), String.join((CharSequence)" | ", typesAssignable)));
        return lines;
    }

    public FormatterClass setInternal(boolean internal) {
        this.internal = internal;
        return this;
    }
}

