/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler.formatter.formatter.jdoc;

import com.probejs.compiler.formatter.formatter.jdoc.DocumentFormatter;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterValue;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentField;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyValue;
import com.probejs.util.Util;
import java.util.ArrayList;
import java.util.List;

public class FormatterField
extends DocumentFormatter<DocumentField> {
    private boolean isInterface = false;

    public FormatterField(DocumentField document) {
        super(document);
    }

    public FormatterField setInterface(boolean anInterface) {
        this.isInterface = anInterface;
        return this;
    }

    public boolean shouldFormatValue() {
        if (!((DocumentField)this.document).isStatic() || ((DocumentField)this.document).getValue() == null || ((DocumentField)this.document).getValue() instanceof PropertyValue.NullValue) {
            return false;
        }
        FormatterValue<?, ?> formatterValue = Serde.getValueFormatter(((DocumentField)this.document).getValue());
        if (formatterValue instanceof FormatterValue.FallbackFormatter) {
            FormatterValue.FallbackFormatter fallback = (FormatterValue.FallbackFormatter)formatterValue;
            return !(fallback.getType() instanceof PropertyType.Parameterized);
        }
        return true;
    }

    @Override
    public List<String> formatDocument(Integer indent, Integer stepIndent) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (((DocumentField)this.document).isStatic() && !this.isInterface) {
            modifiers.add("static");
        }
        if (((DocumentField)this.document).isFinal()) {
            modifiers.add("readonly");
        }
        return List.of(Util.indent(indent) + "%s%s: %s;".formatted(modifiers.isEmpty() ? "" : String.join((CharSequence)" ", modifiers) + " ", Util.getSafeName(((DocumentField)this.document).getName()), this.shouldFormatValue() && !Serde.getValueFormatter(((DocumentField)this.document).getValue()).formatFirst().equals("any") ? Serde.getValueFormatter(((DocumentField)this.document).getValue()).formatFirst() : Serde.getTypeFormatter(((DocumentField)this.document).getType()).formatFieldVariable()));
    }
}

