/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler.formatter.formatter.jdoc;

import com.probejs.compiler.formatter.NameResolver;
import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.compiler.formatter.formatter.jdoc.DocumentFormatter;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocumentBase;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.TypeInfoClass;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyUnderscored;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.util.ClassWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class FormatterType<T extends PropertyType<T>>
extends DocumentFormatter<T> {
    public static Map<Class<? extends PropertyType<?>>, Function<PropertyType<?>, FormatterType<?>>> FORMATTER_REGISTRY = new HashMap();
    protected Boolean underscored = null;

    public FormatterType(T document) {
        super(document);
        ((AbstractDocumentBase)document).findProperty(PropertyUnderscored.class).ifPresent(property -> this.underscored(property.isUnderscored()));
    }

    @Override
    public boolean hasComment() {
        return false;
    }

    @Override
    public boolean canHide() {
        return false;
    }

    public Boolean getUnderscored() {
        return this.underscored != null && this.underscored != false;
    }

    public FormatterType<T> underscored(boolean underscored) {
        if (this.underscored == null) {
            this.underscored = underscored;
        }
        return this;
    }

    public FormatterType<T> underscored() {
        this.underscored(true);
        return this;
    }

    public static <T extends PropertyType<T>> void addFormatter(Class<T> clazz, Function<T, FormatterType<T>> constructor) {
        FORMATTER_REGISTRY.put(clazz, type -> (FormatterType)constructor.apply(type));
    }

    public static void init() {
        FormatterType.addFormatter(PropertyType.Clazz.class, Clazz::new);
        FormatterType.addFormatter(PropertyType.Native.class, Native::new);
        FormatterType.addFormatter(PropertyType.Variable.class, Variable::new);
        FormatterType.addFormatter(PropertyType.Union.class, Union::new);
        FormatterType.addFormatter(PropertyType.Intersection.class, Intersection::new);
        FormatterType.addFormatter(PropertyType.Parameterized.class, Parameterized::new);
        FormatterType.addFormatter(PropertyType.Array.class, Array::new);
        FormatterType.addFormatter(PropertyType.JSObject.class, JSObject::new);
        FormatterType.addFormatter(PropertyType.JSArray.class, JSArray::new);
        FormatterType.addFormatter(PropertyType.TypeOf.class, TypeOf::new);
        FormatterType.addFormatter(PropertyType.JSLambda.class, JSLambda::new);
    }

    public static class JSLambda
    extends FormatterType<PropertyType.JSLambda> {
        private final List<IFormatter> params = new ArrayList<IFormatter>();
        private final FormatterType<?> returns;

        public JSLambda(PropertyType.JSLambda document) {
            super(document);
            document.getParams().forEach(pair -> this.params.add((indent, step) -> List.of("%s: %s".formatted(pair.getFirst(), Serde.getTypeFormatter((PropertyType)pair.getSecond()).formatFirst()))));
            this.returns = Serde.getTypeFormatter(document.getReturns());
        }

        @Override
        protected List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("(%s) => %s".formatted(this.params.stream().map(IFormatter::formatFirst).collect(Collectors.joining(", ")), this.returns.formatFirst()));
        }
    }

    public static class TypeOf
    extends FormatterType<PropertyType.TypeOf> {
        private final FormatterType<?> formatter;

        public TypeOf(PropertyType.TypeOf type) {
            super(type);
            this.formatter = Serde.getTypeFormatter(type.getComponent());
        }

        public TypeOf underscored(boolean underscored) {
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("typeof " + this.formatter.formatFirst());
        }
    }

    public static class JSArray
    extends FormatterType<PropertyType.JSArray> {
        private final List<FormatterType<?>> types = new ArrayList();

        public JSArray(PropertyType.JSArray document) {
            super(document);
            document.getTypes().forEach(type -> this.types.add(Serde.getTypeFormatter(type)));
        }

        @Override
        public FormatterType<PropertyType.JSArray> underscored(boolean underscored) {
            this.types.forEach(type -> type.underscored(underscored));
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("[%s]".formatted(this.types.stream().map(IFormatter::formatFirst).collect(Collectors.joining(", "))));
        }

        @Override
        public String formatAdapted(Function<IFormatter, String> formatterMethod) {
            return "[%s]".formatted(this.types.stream().map(formatterMethod).collect(Collectors.joining(", ")));
        }
    }

    public static class JSObject
    extends FormatterType<PropertyType.JSObject> {
        private final Map<PropertyType.JSObjectKey, FormatterType<?>> keyValues = new HashMap();

        public JSObject(PropertyType.JSObject document) {
            super(document);
            document.getKeyValues().forEach((key, value) -> this.keyValues.put((PropertyType.JSObjectKey)key, Serde.getTypeFormatter(value)));
        }

        public JSObject underscored(boolean underscored) {
            this.keyValues.values().forEach(value -> value.underscored(underscored));
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("{%s}".formatted(this.keyValues.entrySet().stream().map(pair -> {
                PropertyType.JSObjectKey key = (PropertyType.JSObjectKey)pair.getKey();
                FormatterType value = (FormatterType)pair.getValue();
                return "%s: %s".formatted(key.format(), value.formatFirst());
            }).collect(Collectors.joining(", "))));
        }

        @Override
        public String formatAdapted(Function<IFormatter, String> formatterMethod) {
            return "{%s}".formatted(this.keyValues.entrySet().stream().map(pair -> {
                PropertyType.JSObjectKey key = (PropertyType.JSObjectKey)pair.getKey();
                FormatterType value = (FormatterType)pair.getValue();
                return "%s: %s".formatted(key.format(), formatterMethod.apply(value));
            }).collect(Collectors.joining(", ")));
        }
    }

    public static class Array
    extends FormatterType<PropertyType.Array> {
        private final FormatterType<?> formatter;

        public Array(PropertyType.Array type) {
            super(type);
            this.formatter = Serde.getTypeFormatter(type.getComponent());
        }

        public Array underscored(boolean underscored) {
            this.formatter.underscored(underscored);
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            if (this.formatter instanceof Joint) {
                return List.of("(%s)[]".formatted(this.formatter.formatFirst()));
            }
            return List.of(this.formatter.formatFirst() + "[]");
        }

        @Override
        public String formatAdapted(Function<IFormatter, String> formatterMethod) {
            if (this.formatter instanceof Joint) {
                return "(%s)[]".formatted(formatterMethod.apply(this.formatter));
            }
            return formatterMethod.apply(this.formatter) + "[]";
        }
    }

    public static class Parameterized
    extends FormatterType<PropertyType.Parameterized> {
        private static final ITypeInfo CLASS_TYPE = new TypeInfoClass(Class.class);
        private static final ITypeInfo CLASS_WRAPPER_TYPE = new TypeInfoClass(ClassWrapper.class);
        private final FormatterType<?> base;
        private final List<FormatterType<?>> params;

        public Parameterized(PropertyType.Parameterized type) {
            super(type);
            this.base = Serde.getTypeFormatter(type.getBase());
            this.params = type.getParams().stream().map(Serde::getTypeFormatter).map(formatter -> formatter.underscored(false)).collect(Collectors.toList());
        }

        public Parameterized underscored(boolean underscored) {
            this.base.underscored(underscored);
            this.params.forEach(param -> param.underscored(false));
            return this;
        }

        @Override
        public String formatAdapted(Function<IFormatter, String> formatterMethod) {
            if (((PropertyType.Parameterized)this.document).getBase().equalsToJavaType(CLASS_TYPE) || ((PropertyType.Parameterized)this.document).getBase().equalsToJavaType(CLASS_WRAPPER_TYPE)) {
                if (this.params.get(0) instanceof Clazz) {
                    return "typeof %s".formatted(formatterMethod.apply(this.params.get(0)));
                }
                return formatterMethod.apply(this.params.get(0));
            }
            String baseString = formatterMethod.apply(this.base);
            if (this.base instanceof Joint) {
                baseString = "(%s)".formatted(baseString);
            }
            return !baseString.equals("any") ? "%s<%s>".formatted(baseString, this.params.stream().map(formatterMethod).collect(Collectors.joining(", "))) : "any";
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(this.formatAdapted(IFormatter::formatFirst));
        }
    }

    public static class Intersection
    extends Joint<PropertyType.Intersection> {
        public Intersection(PropertyType.Intersection type) {
            super(type);
        }
    }

    public static class Union
    extends Joint<PropertyType.Union> {
        public Union(PropertyType.Union type) {
            super(type);
        }
    }

    public static abstract class Joint<T extends PropertyType.Joint<T>>
    extends FormatterType<T> {
        private final List<FormatterType<?>> types;

        public Joint(T type) {
            super(type);
            this.types = ((PropertyType.Joint)type).getTypes().stream().map(Serde::getTypeFormatter).collect(Collectors.toList());
        }

        @Override
        public Joint<T> underscored(boolean underscored) {
            if (!((PropertyType.Joint)this.document).hasProperty(PropertyUnderscored.class)) {
                this.types.forEach(type -> type.underscored(underscored));
            }
            return this;
        }

        @Override
        public String formatAdapted(Function<IFormatter, String> formatterMethod) {
            return this.types.stream().map(t -> (t instanceof Joint ? "(%s)" : "%s").formatted(formatterMethod.apply((IFormatter)t))).collect(Collectors.joining(((PropertyType.Joint)this.document).getDelimiter()));
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(Util.indent(indent) + this.formatAdapted(IFormatter::formatFirst));
        }
    }

    public static class Variable
    extends Named<PropertyType.Variable> {
        private final List<FormatterType<?>> bounds;

        public Variable(PropertyType.Variable type) {
            super(type);
            this.bounds = type.getBounds().stream().map(Serde::getTypeFormatter).collect(Collectors.toList());
        }

        public Variable underscored(boolean underscored) {
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            this.bounds.removeIf(formatterType -> formatterType.formatFirst().equals("any"));
            if (this.bounds.isEmpty()) {
                return List.of(((PropertyType.Variable)this.document).getTypeName());
            }
            return List.of("%s extends %s".formatted(((PropertyType.Variable)this.document).getTypeName(), this.bounds.stream().map(IFormatter::formatParamVariable).collect(Collectors.joining(" & "))));
        }

        @Override
        public String formatParamVariable() {
            return ((PropertyType.Variable)this.document).getTypeName();
        }

        @Override
        public String formatFieldVariable() {
            return ((PropertyType.Variable)this.document).getTypeName();
        }
    }

    public static class Native
    extends Named<PropertyType.Native> {
        public Native(PropertyType.Native type) {
            super(type);
        }

        public Native underscored(boolean underscored) {
            return this;
        }
    }

    public static class Clazz
    extends Named<PropertyType.Clazz> {
        public Clazz(PropertyType.Clazz type) {
            super(type);
        }

        public Clazz underscored(boolean underscored) {
            if (!NameResolver.resolvedPrimitives.contains(((PropertyType.Clazz)this.document).getClassName())) {
                super.underscored(underscored);
            }
            return this;
        }
    }

    public static abstract class Named<T extends PropertyType.Named<T>>
    extends FormatterType<T> {
        public Named(T type) {
            super(type);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(Util.indent(indent) + ((PropertyType.Named)this.document).getTypeName() + (this.getUnderscored() != false ? "_" : ""));
        }
    }
}

