/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler.formatter.formatter.jdoc;

import com.probejs.ProbeJS;
import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.compiler.formatter.formatter.jdoc.DocumentFormatter;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterType;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyValue;
import dev.latvian.mods.rhino.ScriptableObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class FormatterValue<T extends PropertyValue<T, J>, J>
extends DocumentFormatter<T>
implements IFormatter {
    public static Map<Class<?>, Function<PropertyValue<?, ?>, FormatterValue<?, ?>>> VALUE_FORMATTERS_REGISTRY = new HashMap();

    public FormatterValue(T document) {
        super(document);
    }

    @Override
    public boolean hasComment() {
        return false;
    }

    @Override
    public boolean canHide() {
        return false;
    }

    public static <T extends PropertyValue<T, J>, J> void addValueFormatter(Class<T> clazz, Function<T, FormatterValue<T, J>> constructor) {
        VALUE_FORMATTERS_REGISTRY.put(clazz, value -> (FormatterValue)constructor.apply(value));
    }

    public static void init() {
        FormatterValue.addValueFormatter(PropertyValue.NumberValue.class, PrimitiveFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.BooleanValue.class, PrimitiveFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.StringValue.class, PrimitiveFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.CharacterValue.class, PrimitiveFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.FallbackValue.class, FallbackFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.MapValue.class, MapFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.ListValue.class, ListFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.ObjectValue.class, ObjectFormatter::new);
        FormatterValue.addValueFormatter(PropertyValue.NullValue.class, NullFormatter::new);
    }

    public static class NullFormatter
    extends FormatterValue<PropertyValue.NullValue, Object> {
        public NullFormatter(PropertyValue.NullValue document) {
            super(document);
        }

        @Override
        protected List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("null");
        }
    }

    public static class ObjectFormatter
    extends FormatterValue<PropertyValue.ObjectValue, ScriptableObject> {
        public ObjectFormatter(PropertyValue.ObjectValue document) {
            super(document);
        }

        @Override
        protected List<String> formatDocument(Integer indent, Integer stepIndent) {
            if (((PropertyValue.ObjectValue)this.document).getTypeName() == null) {
                return List.of(((PropertyValue.ObjectValue)this.document).getTypeName());
            }
            return List.of("{%s}".formatted(((PropertyValue.ObjectValue)this.document).getKeyValues().entrySet().stream().map(entry -> {
                FormatterValue<?, ?> key = Serde.getValueFormatter((PropertyValue)entry.getKey());
                FormatterValue<?, ?> value = Serde.getValueFormatter((PropertyValue)entry.getValue());
                if (key != null && value != null) {
                    return "%s: %s".formatted(key.formatFirst(), value.formatFirst());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.joining(", "))));
        }
    }

    public static class ListFormatter
    extends FormatterValue<PropertyValue.ListValue, List<?>> {
        public ListFormatter(PropertyValue.ListValue document) {
            super(document);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("[%s]".formatted(((List)((PropertyValue.ListValue)this.document).getValue()).stream().map(Serde::getValueProperty).map(Serde::getValueFormatter).filter(Objects::nonNull).map(IFormatter::formatFirst).collect(Collectors.joining(", "))));
        }
    }

    public static class MapFormatter
    extends FormatterValue<PropertyValue.MapValue, Map<?, ?>> {
        public MapFormatter(PropertyValue.MapValue document) {
            super(document);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("{%s}".formatted(((Map)((PropertyValue.MapValue)this.document).getValue()).entrySet().stream().map(entry -> {
                FormatterValue<?, ?> keyValue = Serde.getValueFormatter(Serde.getValueProperty(entry.getKey()));
                FormatterValue<?, ?> propertyValue = Serde.getValueFormatter(Serde.getValueProperty(entry.getValue()));
                if (keyValue != null && propertyValue != null) {
                    return (keyValue instanceof FallbackFormatter ? "[key: %s]: %s" : "%s: %s").formatted(keyValue.formatFirst(), propertyValue.formatFirst());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.joining(", "))));
        }
    }

    public static class FallbackFormatter
    extends FormatterValue<PropertyValue.FallbackValue, Object> {
        public FallbackFormatter(PropertyValue.FallbackValue document) {
            super(document);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            PropertyType<?> type = ((PropertyValue.FallbackValue)this.document).getType();
            FormatterType<?> typeFormatter = Serde.getTypeFormatter(type);
            return List.of(typeFormatter.formatFirst());
        }

        public PropertyType<?> getType() {
            return ((PropertyValue.FallbackValue)this.document).getType();
        }
    }

    public static class PrimitiveFormatter<T extends PropertyValue<T, J>, J>
    extends FormatterValue<T, J> {
        public PrimitiveFormatter(T document) {
            super(document);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(ProbeJS.GSON.toJson(((PropertyValue)this.document).getValue()));
        }
    }
}

