/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.probejs.ProbeJS;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterType;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterValue;
import com.probejs.jdoc.ISerde;
import com.probejs.jdoc.document.AbstractDocumentBase;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.document.DocumentConstructor;
import com.probejs.jdoc.document.DocumentField;
import com.probejs.jdoc.document.DocumentMethod;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.TypeInfoArray;
import com.probejs.jdoc.java.type.TypeInfoClass;
import com.probejs.jdoc.java.type.TypeInfoParameterized;
import com.probejs.jdoc.java.type.TypeInfoVariable;
import com.probejs.jdoc.java.type.TypeInfoWildcard;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyAssign;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.jdoc.property.PropertyExtra;
import com.probejs.jdoc.property.PropertyHide;
import com.probejs.jdoc.property.PropertyModify;
import com.probejs.jdoc.property.PropertyParam;
import com.probejs.jdoc.property.PropertyReturns;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyUnderscored;
import com.probejs.jdoc.property.PropertyValue;
import com.probejs.jdoc.property.condition.PropertyMod;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class Serde {
    public static void init() {
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Array.class, (Object)"type:array");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Clazz.class, (Object)"type:class");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Parameterized.class, (Object)"type:parameterized");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Variable.class, (Object)"type:variable");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Native.class, (Object)"type:primitive");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Intersection.class, (Object)"type:intersection");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Union.class, (Object)"type:union");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.JSObject.class, (Object)"type:object");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.JSArray.class, (Object)"type:jsArray");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.TypeOf.class, (Object)"type:typeof");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.JSLambda.class, (Object)"type:lambda");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyComment.class, (Object)"property:comment");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyHide.class, (Object)"property:hide");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyMod.class, (Object)"property:mod");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyModify.class, (Object)"property:modify");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyReturns.class, (Object)"property:returns");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyParam.class, (Object)"property:param");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyAssign.class, (Object)"property:assign");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyExtra.class, (Object)"property:extra");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyUnderscored.class, (Object)"property:underscored");
        AbstractDocumentBase.DOCUMENT_TYPE_REGISTRY.put(DocumentClass.class, (Object)"document:class");
        AbstractDocumentBase.DOCUMENT_TYPE_REGISTRY.put(DocumentMethod.class, (Object)"document:method");
        AbstractDocumentBase.DOCUMENT_TYPE_REGISTRY.put(DocumentField.class, (Object)"document:field");
        AbstractDocumentBase.DOCUMENT_TYPE_REGISTRY.put(DocumentConstructor.class, (Object)"document:constructor");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.NumberValue.class, (Object)"value:number");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.BooleanValue.class, (Object)"value:boolean");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.StringValue.class, (Object)"value:string");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.CharacterValue.class, (Object)"value:character");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.FallbackValue.class, (Object)"value:fallback");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.NullValue.class, (Object)"value:null");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.MapValue.class, (Object)"value:map");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.ListValue.class, (Object)"value:list");
        PropertyValue.init();
        FormatterValue.init();
        FormatterType.init();
    }

    public static AbstractDocumentBase<?> deserializeDocument(JsonObject obj) {
        String type = obj.get("type").getAsString();
        try {
            AbstractDocumentBase doc = (AbstractDocumentBase)((Class)AbstractDocumentBase.DOCUMENT_TYPE_REGISTRY.inverse().get((Object)type)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            doc.deserialize(obj);
            return doc;
        }
        catch (Exception e) {
            ProbeJS.LOGGER.warn("Error occurred while deserializing document with type \"%s\"! If this is a user-defined document, it might be an error in docs. If it's not, then possibly it's because current doc requires a newer version of ProbeJS to load!".formatted(type));
            return null;
        }
    }

    public static AbstractProperty<?> deserializeProperty(JsonObject obj) {
        String type = obj.get("type").getAsString();
        try {
            AbstractProperty property = (AbstractProperty)((Class)AbstractProperty.DOCUMENT_TYPE_REGISTRY.inverse().get((Object)type)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            property.deserialize(obj);
            return property;
        }
        catch (Exception e) {
            ProbeJS.LOGGER.warn("Error occurred while deserializing document with type \"%s\"! If this is a user-defined document, it might be an error in docs. If it's not, then possibly it's because current doc requires a newer version of ProbeJS to load!".formatted(type));
            return null;
        }
    }

    private static PropertyType<?> constructType(Supplier<PropertyType<?>> builder, ITypeInfo type) {
        PropertyType<?> property = builder.get();
        property.fromJava(type);
        return property;
    }

    public static PropertyType<?> deserializeFromJavaType(ITypeInfo type, boolean insideType) {
        if (type instanceof TypeInfoArray) {
            return Serde.constructType(PropertyType.Array::new, type);
        }
        if (type instanceof TypeInfoClass) {
            TypeInfoClass clazz = (TypeInfoClass)type;
            if (!clazz.getTypeVariables().isEmpty() && !insideType) {
                return Serde.constructType(PropertyType.Parameterized::new, clazz);
            }
            return Serde.constructType(PropertyType.Clazz::new, clazz);
        }
        if (type instanceof TypeInfoVariable) {
            return Serde.constructType(PropertyType.Variable::new, type);
        }
        if (type instanceof TypeInfoParameterized) {
            return Serde.constructType(PropertyType.Parameterized::new, type);
        }
        if (type instanceof TypeInfoWildcard) {
            TypeInfoWildcard wildcard = (TypeInfoWildcard)type;
            return Serde.deserializeFromJavaType(wildcard.getBaseType(), false);
        }
        return null;
    }

    public static PropertyType<?> deserializeFromJavaType(ITypeInfo type) {
        return Serde.deserializeFromJavaType(type, false);
    }

    public static void serializeCollection(JsonObject object, String key, Iterable<? extends ISerde> serdes) {
        Serde.serializeCollection(object, key, serdes, false);
    }

    public static void serializeCollection(JsonObject object, String key, Iterable<? extends ISerde> serdes, boolean skipIfEmpty) {
        if (serdes == null) {
            return;
        }
        JsonArray result = new JsonArray();
        serdes.forEach(serde -> result.add((JsonElement)serde.serialize()));
        if (result.isEmpty() && skipIfEmpty) {
            return;
        }
        object.add(key, (JsonElement)result);
    }

    public static <T extends AbstractDocumentBase<?>> void deserializeDocuments(Collection<T> serdes, JsonElement jsonArray) {
        if (jsonArray == null || serdes == null) {
            return;
        }
        for (JsonElement element : jsonArray.getAsJsonArray()) {
            AbstractDocumentBase<?> document = Serde.deserializeDocument(element.getAsJsonObject());
            if (document == null || !document.fulfillsConditions()) continue;
            serdes.add(document);
        }
    }

    @Nonnull
    public static PropertyValue<?, ?> getValueProperty(Object o) {
        if (o == null) {
            return new PropertyValue.NullValue();
        }
        Function<Object, PropertyValue<?, ?>> constructor = PropertyValue.VALUES_REGISTRY.get(o.getClass());
        if (constructor != null) {
            return constructor.apply(o);
        }
        for (Map.Entry<Class<?>, Function<Object, PropertyValue<?, ?>>> entry : PropertyValue.VALUES_REGISTRY.entrySet()) {
            Class<?> clazz = entry.getKey();
            Function<Object, PropertyValue<?, ?>> subConstructor = entry.getValue();
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return subConstructor.apply(o);
        }
        return new PropertyValue.FallbackValue(o);
    }

    public static FormatterValue<?, ?> getValueFormatter(PropertyValue<?, ?> property) {
        Function<PropertyValue<?, ?>, FormatterValue<?, ?>> constructor = FormatterValue.VALUE_FORMATTERS_REGISTRY.get(property.getClass());
        if (constructor != null) {
            return constructor.apply(property);
        }
        return null;
    }

    public static FormatterType<?> getTypeFormatter(PropertyType<?> type) {
        Function<PropertyType<?>, FormatterType<?>> constructor = FormatterType.FORMATTER_REGISTRY.get(type.getClass());
        if (constructor != null) {
            return constructor.apply(type);
        }
        return new FormatterType.Native(new PropertyType.Native("any"));
    }

    public static JsonElement getPrimitive(Object o) {
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return new JsonPrimitive(bool);
        }
        if (o instanceof String) {
            String string = (String)o;
            return new JsonPrimitive(string);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new JsonPrimitive(number);
        }
        if (o instanceof Character) {
            Character character = (Character)o;
            return new JsonPrimitive(character);
        }
        throw new IllegalArgumentException("The argument is not primitive type!");
    }

    public static Object getAsPrimitive(JsonElement element) {
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new IllegalArgumentException("The argument is not primitive value!");
    }
}

