/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.jdoc.JsAnnotations;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.document.DocumentConstructor;
import com.probejs.jdoc.document.DocumentField;
import com.probejs.jdoc.document.DocumentMethod;
import com.probejs.jdoc.java.ClassInfo;
import com.probejs.jdoc.property.PropertyType;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DocumentClass
extends AbstractDocument<DocumentClass> {
    protected String name;
    protected List<PropertyType<?>> generics = new ArrayList();
    protected PropertyType<?> parent;
    public Set<PropertyType<?>> interfaces = new HashSet();
    public Set<DocumentField> fields = new HashSet<DocumentField>();
    public Set<DocumentMethod> methods = new HashSet<DocumentMethod>();
    public Set<DocumentConstructor> constructors = new HashSet<DocumentConstructor>();
    protected boolean isAbstract = false;
    protected boolean isInterface = false;
    protected boolean isFunctionalInterface = false;

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("className", this.name);
        object.addProperty("abstract", Boolean.valueOf(this.isAbstract));
        object.addProperty("interface", Boolean.valueOf(this.isInterface));
        if (this.parent != null) {
            object.add("parent", (JsonElement)this.parent.serialize());
        }
        Serde.serializeCollection(object, "fields", this.fields);
        Serde.serializeCollection(object, "methods", this.methods);
        Serde.serializeCollection(object, "variables", this.generics, true);
        Serde.serializeCollection(object, "interfaces", this.interfaces, true);
        Serde.serializeCollection(object, "constructors", this.constructors);
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        super.deserialize(object);
        this.name = object.get("className").getAsString();
        if (object.has("parent")) {
            this.parent = (PropertyType)Serde.deserializeProperty(object.get("parent").getAsJsonObject());
        }
        if (object.has("abstract")) {
            this.isAbstract = object.get("abstract").getAsBoolean();
        }
        if (object.has("interface")) {
            this.isInterface = object.get("interface").getAsBoolean();
        }
        Serde.deserializeDocuments(this.fields, object.get("fields"));
        Serde.deserializeDocuments(this.methods, object.get("methods"));
        Serde.deserializeDocuments(this.constructors, object.get("constructors"));
        Serde.deserializeDocuments(this.generics, object.get("variables"));
        Serde.deserializeDocuments(this.interfaces, object.get("interfaces"));
    }

    public static DocumentClass fromJava(ClassInfo info) {
        DocumentClass document = new DocumentClass();
        document.name = info.getName();
        document.isAbstract = info.isAbstract();
        document.isInterface = info.isInterface();
        document.isFunctionalInterface = document.isInterface && info.getAnnotations().stream().anyMatch(ann -> ann instanceof FunctionalInterface);
        document.parent = info.getSuperClass() != null ? Serde.deserializeFromJavaType(info.getSuperClassType()) : null;
        document.interfaces.addAll(info.getInterfaceTypes().stream().map(Serde::deserializeFromJavaType).toList());
        document.generics.addAll(info.getParameters().stream().map(Serde::deserializeFromJavaType).toList());
        info.getFieldInfo().stream().map(DocumentField::fromJava).forEach(document.fields::add);
        info.getMethodInfo().stream().map(DocumentMethod::fromJava).forEach(document.methods::add);
        info.getConstructorInfo().stream().map(DocumentConstructor::fromJava).forEach(document.constructors::add);
        info.getAnnotations().stream().filter(annotation -> annotation instanceof Deprecated).findFirst().ifPresent(annotation -> {
            document.builtinComments.add("@deprecated");
            if (((Deprecated)annotation).forRemoval()) {
                document.builtinComments.add("This class is marked to be removed in future!");
            }
        });
        info.getAnnotations().stream().filter(annotation -> annotation instanceof Info).findFirst().ifPresent(annotation -> {
            document.builtinComments = document.builtinComments.merge(JsAnnotations.fromAnnotation((Info)annotation, true));
        });
        return document;
    }

    @Override
    public DocumentClass applyProperties() {
        return this;
    }

    @Override
    public DocumentClass merge(DocumentClass other) {
        if (this == other) {
            return this;
        }
        DocumentClass document = other.copy();
        document.parent = this.parent;
        document.interfaces.addAll(this.interfaces);
        document.methods.addAll(this.methods);
        document.fields.addAll(this.fields);
        document.properties.addAll(this.properties);
        document.constructors = this.constructors;
        document.generics.addAll(this.generics);
        document.isInterface = this.isInterface;
        document.isAbstract = this.isAbstract;
        document.builtinComments = document.builtinComments.merge(this.builtinComments);
        return document;
    }

    @Override
    public DocumentClass copy() {
        DocumentClass document = new DocumentClass();
        document.name = this.name;
        document.parent = this.parent;
        document.isInterface = this.isInterface;
        document.isAbstract = this.isAbstract;
        document.interfaces.addAll(this.interfaces);
        document.properties.addAll(this.properties);
        document.methods.addAll(this.methods);
        document.fields.addAll(this.fields);
        document.builtinComments.merge(this.builtinComments);
        return document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentClass that = (DocumentClass)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public Set<DocumentConstructor> getConstructors() {
        return this.constructors;
    }

    public Set<DocumentMethod> getMethods() {
        return this.methods;
    }

    public Set<DocumentField> getFields() {
        return this.fields;
    }

    public Set<PropertyType<?>> getInterfaces() {
        return this.interfaces;
    }

    public List<PropertyType<?>> getGenerics() {
        return this.generics;
    }

    public PropertyType<?> getParent() {
        return this.parent;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isFunctionalInterface() {
        return this.isFunctionalInterface;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public void setInterface(boolean anInterface) {
        this.isInterface = anInterface;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(PropertyType<?> parent) {
        this.parent = parent;
    }
}

