/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.jdoc.JsAnnotations;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.java.MethodInfo;
import com.probejs.jdoc.property.PropertyModify;
import com.probejs.jdoc.property.PropertyParam;
import com.probejs.jdoc.property.PropertyReturns;
import com.probejs.jdoc.property.PropertyType;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentMethod
extends AbstractDocument<DocumentMethod> {
    public String name;
    public boolean isStatic;
    public boolean isAbstract;
    public PropertyType<?> returns;
    public final List<PropertyParam> params = new ArrayList<PropertyParam>();
    public final List<PropertyType<?>> variables = new ArrayList();

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("name", this.name);
        object.addProperty("static", Boolean.valueOf(this.isStatic));
        object.addProperty("abstract", Boolean.valueOf(this.isAbstract));
        Serde.serializeCollection(object, "params", this.params);
        Serde.serializeCollection(object, "variables", this.variables);
        object.add("returns", (JsonElement)this.returns.serialize());
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        super.deserialize(object);
        this.name = object.get("name").getAsString();
        if (object.has("static")) {
            this.isStatic = object.get("static").getAsBoolean();
        }
        if (object.has("abstract")) {
            this.isAbstract = object.get("abstract").getAsBoolean();
        }
        Serde.deserializeDocuments(this.params, object.get("params"));
        Serde.deserializeDocuments(this.variables, object.get("variables"));
        this.returns = (PropertyType)Serde.deserializeProperty(object.get("returns").getAsJsonObject());
    }

    public static DocumentMethod fromJava(MethodInfo info) {
        DocumentMethod document = new DocumentMethod();
        document.name = info.getName();
        document.returns = Serde.deserializeFromJavaType(info.getReturnType());
        document.isStatic = info.isStatic();
        document.isAbstract = info.isAbstract();
        info.getParams().stream().map(PropertyParam::fromJava).forEach(document.params::add);
        info.getAnnotations().stream().filter(annotation -> annotation instanceof Deprecated).findFirst().ifPresent(annotation -> {
            document.builtinComments.add("@deprecated");
            if (((Deprecated)annotation).forRemoval()) {
                document.builtinComments.add("This method is marked to be removed in future!");
            }
        });
        info.getAnnotations().stream().filter(annotation -> annotation instanceof Info).findFirst().ifPresent(annotation -> {
            document.builtinComments = document.builtinComments.merge(JsAnnotations.fromAnnotation((Info)annotation, true));
        });
        info.getTypeVariables().stream().map(Serde::deserializeFromJavaType).forEach(document.variables::add);
        return document;
    }

    @Override
    public DocumentMethod applyProperties() {
        DocumentMethod copy = this.copy();
        copy.findPropertiesOf(PropertyModify.class).forEach(modify -> {
            PropertyParam param = copy.params.get(modify.getOrdinal());
            copy.params.set(modify.getOrdinal(), new PropertyParam(modify.getName() != null ? modify.getName() : param.getName(), modify.getNewType() != null ? modify.getNewType() : param.getType(), param.isVarArg()));
        });
        copy.findProperty(PropertyReturns.class).ifPresent(propertyReturns -> {
            copy.returns = propertyReturns.getType();
        });
        return copy;
    }

    @Override
    public DocumentMethod copy() {
        DocumentMethod document = new DocumentMethod();
        document.name = this.name;
        document.params.addAll(this.params);
        document.returns = this.returns;
        document.properties.addAll(this.properties);
        document.variables.addAll(this.variables);
        document.isStatic = this.isStatic;
        document.isAbstract = this.isAbstract;
        document.builtinComments = this.builtinComments.copy();
        return document;
    }

    @Override
    public DocumentMethod merge(DocumentMethod other) {
        DocumentMethod merged = super.merge(other);
        merged.builtinComments = this.builtinComments.merge(other.builtinComments);
        return merged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMethod that = (DocumentMethod)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.params, that.params) && Objects.equals(this.returns, that.returns);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.params, this.returns);
    }

    public String getName() {
        return this.name;
    }

    public List<PropertyParam> getParams() {
        return this.params;
    }

    public PropertyType<?> getReturns() {
        return this.returns;
    }

    public List<PropertyType<?>> getVariables() {
        return this.variables;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }
}

