/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java;

import com.probejs.jdoc.java.ClassInfo;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import com.probejs.jdoc.java.type.TypeInfoClass;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.Remapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MethodInfo {
    private final String name;
    private final boolean shouldHide;
    private final boolean defaultMethod;
    private final int modifiers;
    private final Method method;
    private final Class<?> from;
    private ITypeInfo returnType;
    private List<ParamInfo> params;
    private List<ITypeInfo> typeVariables;
    private final List<Annotation> annotations;
    public static final Remapper RUNTIME = RemappingHelper.getMinecraftRemapper();

    public static String getRemappedOrOriginalClass(Class<?> clazz) {
        String remapped = RUNTIME.getMappedClass(clazz);
        if (remapped.equals("")) {
            remapped = clazz.getName();
        }
        return remapped;
    }

    public static Optional<JavaMembers.MethodInfo> getMethodInfo(Method method, Class<?> from) {
        ScriptManager scriptManager = ServerScriptManager.getScriptManager();
        JavaMembers members = JavaMembers.lookupClass((Context)scriptManager.context, (Scriptable)scriptManager.topLevelScope, from, from, (boolean)false);
        return members.getAccessibleMethods(scriptManager.context, false).stream().filter(methodInfo -> methodInfo.method.equals(method)).findFirst();
    }

    public MethodInfo(JavaMembers.MethodInfo methodInfo, Class<?> from) {
        Method method = methodInfo.method;
        HashMap<Type, Type> typeGenericMap = new HashMap<Type, Type>();
        if (method.getDeclaringClass() != from) {
            typeGenericMap.putAll(MethodInfo.rewindGenerics(method, from));
        }
        this.method = method;
        this.name = methodInfo.name.isEmpty() ? method.getName() : methodInfo.name;
        this.shouldHide = false;
        this.from = from;
        this.modifiers = method.getModifiers();
        try {
            this.returnType = InfoTypeResolver.resolveType(method.getGenericReturnType(), type -> typeGenericMap.getOrDefault(type, (Type)type));
        }
        catch (Exception e) {
            this.returnType = new TypeInfoClass(Object.class);
        }
        this.params = Arrays.stream(method.getParameters()).map(param -> new ParamInfo((Parameter)param, (Map<Type, Type>)typeGenericMap)).collect(Collectors.toList());
        this.typeVariables = Arrays.stream(method.getTypeParameters()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
        this.defaultMethod = method.isDefault();
        this.annotations = List.of(method.getAnnotations());
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldHide() {
        return this.shouldHide;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers) && !this.from.isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public ITypeInfo getReturnType() {
        return this.returnType;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public List<ITypeInfo> getTypeVariables() {
        return this.typeVariables;
    }

    public ClassInfo getFrom() {
        return ClassInfo.getOrCache(this.from);
    }

    public void setParams(List<ParamInfo> params) {
        this.params = params;
    }

    public void setReturnType(ITypeInfo returnType) {
        this.returnType = returnType;
    }

    public void setTypeVariables(List<ITypeInfo> typeVariables) {
        this.typeVariables = typeVariables;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Method getMethod() {
        return this.method;
    }

    private static Class<?> unwrapGenerics(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return MethodInfo.unwrapGenerics(parameterizedType.getRawType());
        }
        return null;
    }

    private static boolean testTypeAssignable(Type type1, Type type2) {
        Class<?> clazz1 = MethodInfo.unwrapGenerics(type1);
        Class<?> clazz2 = MethodInfo.unwrapGenerics(type2);
        return clazz1 != null && clazz2 != null && clazz1.isAssignableFrom(clazz2);
    }

    private static Map<Type, Type> rewindGenerics(Method method, Class<?> currentClass) {
        Map<Type, Type> currentMap;
        block7: {
            block5: {
                Type parentType;
                block6: {
                    Class<?> targetClass = method.getDeclaringClass();
                    currentMap = new HashMap<Type, Type>();
                    if (targetClass == currentClass) break block5;
                    Type type = parentType = MethodInfo.testTypeAssignable(targetClass, currentClass.getGenericSuperclass()) ? currentClass.getGenericSuperclass() : (Type)Arrays.stream(currentClass.getGenericInterfaces()).filter(i -> MethodInfo.testTypeAssignable(targetClass, i)).findFirst().orElse(null);
                    if (!(parentType instanceof ParameterizedType)) break block6;
                    ParameterizedType parameterizedType = (ParameterizedType)parentType;
                    Class<?> paramClass = MethodInfo.unwrapGenerics(parameterizedType);
                    if (paramClass != null) {
                        Type[] remappedTypes = parameterizedType.getActualTypeArguments();
                        TypeVariable<Class<?>>[] originalTypes = paramClass.getTypeParameters();
                        for (int i2 = 0; i2 < remappedTypes.length; ++i2) {
                            currentMap.put(originalTypes[i2], remappedTypes[i2]);
                        }
                    }
                    Map<Type, Type> parentMap = MethodInfo.rewindGenerics(method, MethodInfo.unwrapGenerics(parentType));
                    HashMap<Type, Type> mutMap = new HashMap<Type, Type>();
                    for (Type key : parentMap.keySet()) {
                        if (currentMap.containsKey(parentMap.get(key))) {
                            mutMap.put(key, currentMap.get(parentMap.get(key)));
                            continue;
                        }
                        mutMap.put(key, parentMap.get(key));
                    }
                    currentMap = mutMap;
                    break block7;
                }
                if (parentType == null) break block7;
                currentMap = MethodInfo.rewindGenerics(method, MethodInfo.unwrapGenerics(parentType));
                break block7;
            }
            for (TypeVariable<Class<?>> type : currentClass.getTypeParameters()) {
                currentMap.put(type, type);
            }
        }
        return currentMap;
    }

    public static class ParamInfo {
        private final String name;
        private final boolean isVararg;
        private ITypeInfo type;

        public ParamInfo(Parameter parameter) {
            this(parameter, new HashMap<Type, Type>());
        }

        public ParamInfo(Parameter parameter, Map<Type, Type> typeMap) {
            this.name = parameter.getName();
            this.isVararg = parameter.isVarArgs();
            try {
                this.type = InfoTypeResolver.resolveType(parameter.getParameterizedType(), t -> typeMap.getOrDefault(t, (Type)t));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.type = new TypeInfoClass(Object.class);
            }
        }

        public String getName() {
            return this.name;
        }

        public ITypeInfo getType() {
            return this.type;
        }

        public boolean isVararg() {
            return this.isVararg;
        }

        public void setTypeInfo(ITypeInfo type) {
            this.type = type;
        }
    }
}

