/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java.type;

import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import com.probejs.jdoc.java.type.TypeInfoClass;
import com.probejs.jdoc.java.type.TypeInfoParameterized;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeInfoVariable
implements ITypeInfo {
    private final TypeVariable<?> type;
    private final List<ITypeInfo> bounds = new ArrayList<ITypeInfo>();
    private boolean underscored = false;

    public static boolean test(Type type) {
        return type instanceof TypeVariable;
    }

    public TypeInfoVariable(Type type, Function<Type, Type> typeTransformer) {
        this(type, typeTransformer, true);
    }

    public TypeInfoVariable(Type type, Function<Type, Type> typeTransformer, boolean checkBounds) {
        TypeVariable inner;
        this.type = inner = (TypeVariable)type;
        if (checkBounds) {
            for (Type bound : inner.getBounds()) {
                if (bound instanceof ParameterizedType) {
                    ParameterizedType parameterized = (ParameterizedType)bound;
                    this.bounds.add(new TypeInfoParameterized(InfoTypeResolver.resolveType(parameterized.getRawType()), Arrays.stream(parameterized.getActualTypeArguments()).map(t -> {
                        if (t instanceof TypeVariable) {
                            TypeVariable variable = (TypeVariable)t;
                            return new TypeInfoVariable(variable, typeTransformer, false);
                        }
                        if (t instanceof WildcardType) {
                            WildcardType wildcardType = (WildcardType)t;
                            Type[] upper = wildcardType.getUpperBounds();
                            Type[] lower = wildcardType.getLowerBounds();
                            Object wild = upper[0] != Object.class ? upper[0] : (lower.length != 0 ? lower[0] : Object.class);
                            if (wild instanceof TypeVariable) {
                                wild = Object.class;
                            }
                            return InfoTypeResolver.resolveType(wild);
                        }
                        return InfoTypeResolver.resolveType(t);
                    }).collect(Collectors.toList())));
                    continue;
                }
                this.bounds.add(InfoTypeResolver.resolveType(bound, typeTransformer));
            }
        }
        this.bounds.removeIf(typeInfo -> {
            TypeInfoClass clazz;
            return typeInfo instanceof TypeInfoClass && (clazz = (TypeInfoClass)typeInfo).getResolvedClass().equals(Object.class);
        });
    }

    private TypeInfoVariable(TypeVariable<?> inner) {
        this.type = inner;
    }

    public void setUnderscored(boolean underscored) {
        this.underscored = underscored;
    }

    @Override
    public ITypeInfo getBaseType() {
        return this;
    }

    @Override
    public String getTypeName() {
        return this.type.getName();
    }

    @Override
    public ITypeInfo copy() {
        TypeInfoVariable copied = new TypeInfoVariable(this.type);
        copied.bounds.addAll(this.bounds);
        copied.setUnderscored(this.underscored);
        return copied;
    }

    @Override
    public boolean assignableFrom(ITypeInfo info) {
        return info instanceof TypeInfoVariable;
    }

    @Override
    public boolean equalsTo(ITypeInfo info) {
        return info instanceof TypeInfoVariable;
    }

    @Override
    public Class<?> getResolvedClass() {
        if (this.bounds.size() == 1) {
            return this.bounds.get(0).getResolvedClass();
        }
        return Object.class;
    }

    public List<ITypeInfo> getBounds() {
        return this.bounds;
    }
}

